/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.handler;

import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseFormResolverTest<T extends ProviderConfigurationForm> {
    protected FormResolver<T> formResolver;
    @Mock
    protected ManagedInstance<T> managedInstance;
    @Mock
    protected T form;

    @Before
    public void setUp() {
        Mockito.when((Object)this.managedInstance.get()).thenReturn(this.form);
        this.formResolver = this.createFormResolver(this.managedInstance);
    }

    @Test
    public void testNewProviderConfigurationForm() {
        ProviderConfigurationForm result = this.formResolver.newProviderConfigurationForm();
        Assert.assertEquals(this.form, (Object)result);
        ((ManagedInstance)Mockito.verify(this.managedInstance, (VerificationMode)Mockito.times((int)1))).get();
    }

    @Test
    public void testDestroyForm() {
        this.formResolver.destroyForm(this.form);
        ((ManagedInstance)Mockito.verify(this.managedInstance, (VerificationMode)Mockito.times((int)1))).destroy(this.form);
    }

    @Test
    public void testDestroyNullForm() {
        this.formResolver.destroyForm(null);
        ((ManagedInstance)Mockito.verify(this.managedInstance, (VerificationMode)Mockito.never())).destroy(ArgumentMatchers.anyObject());
    }

    protected abstract FormResolver<T> createFormResolver(ManagedInstance<T> var1);
}

