/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.providertype;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.wizard.providertype.EnableProviderTypePagePresenter;
import org.guvnor.ala.ui.client.wizard.providertype.item.ProviderTypeItemPresenter;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class EnableProviderTypePagePresenterTest {
    @Mock
    private EnableProviderTypePagePresenter.View view;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    @Mock
    private ManagedInstance<ProviderTypeItemPresenter> providerTypeItemPresenterInstance;
    private EnableProviderTypePagePresenter presenter;
    private List<ProviderType> providerTypes;
    private List<Pair<ProviderType, ProviderTypeStatus>> providerTypeStatus;
    private static int PROVIDERS_COUNT = 3;

    @Before
    public void setUp() {
        this.providerTypes = ProvisioningManagementTestCommons.mockProviderTypeList((int)PROVIDERS_COUNT);
        this.providerTypeStatus = ProvisioningManagementTestCommons.buildProviderTypeStatusList(this.providerTypes, (ProviderTypeStatus)ProviderTypeStatus.DISABLED);
        this.presenter = new EnableProviderTypePagePresenter(this.view, (Event)this.wizardPageStatusChangeEvent, (ManagedInstance)this.providerTypeItemPresenterInstance){

            protected ProviderTypeItemPresenter newProviderTypeItemPresenter() {
                ProviderTypeItemPresenter itemPresenter = (ProviderTypeItemPresenter)Mockito.mock(ProviderTypeItemPresenter.class);
                Mockito.when((Object)itemPresenter.getView()).thenReturn(Mockito.mock(IsElement.class));
                Mockito.when((Object)EnableProviderTypePagePresenterTest.this.providerTypeItemPresenterInstance.get()).thenReturn((Object)itemPresenter);
                return super.newProviderTypeItemPresenter();
            }
        };
        this.presenter.init();
        ((EnableProviderTypePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        this.presenter.setup(this.providerTypeStatus);
        ((EnableProviderTypePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertEquals((long)this.providerTypeStatus.size(), (long)this.presenter.getItemPresenters().size());
        for (int i = 0; i < this.presenter.getItemPresenters().size(); ++i) {
            ProviderTypeItemPresenter itemPresenter = (ProviderTypeItemPresenter)this.presenter.getItemPresenters().get(i);
            Pair<ProviderType, ProviderTypeStatus> pair = this.providerTypeStatus.get(i);
            ((ProviderTypeItemPresenter)Mockito.verify((Object)itemPresenter, (VerificationMode)Mockito.times((int)1))).setup((ProviderType)pair.getK1(), (ProviderTypeStatus)pair.getK2());
            ((ProviderTypeItemPresenter)Mockito.verify((Object)itemPresenter, (VerificationMode)Mockito.times((int)1))).addContentChangeHandler((ContentChangeHandler)ArgumentMatchers.any(ContentChangeHandler.class));
            ((EnableProviderTypePagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addProviderType(itemPresenter.getView());
        }
        ((ManagedInstance)Mockito.verify(this.providerTypeItemPresenterInstance, (VerificationMode)Mockito.times((int)this.providerTypeStatus.size()))).get();
    }

    @Test
    public void testPageNotCompleted() {
        this.presenter.setup(this.providerTypeStatus);
        this.presenter.getItemPresenters().forEach(itemPresenter -> Mockito.when((Object)itemPresenter.isSelected()).thenReturn((Object)false));
        this.presenter.isComplete(Assert::assertFalse);
    }

    @Test
    public void testPageCompleted() {
        this.presenter.setup(this.providerTypeStatus);
        this.presenter.getItemPresenters().forEach(itemPresenter -> Mockito.when((Object)itemPresenter.isSelected()).thenReturn((Object)false));
        int selected1 = 0;
        int selected2 = 2;
        Mockito.when((Object)((ProviderTypeItemPresenter)this.presenter.getItemPresenters().get(selected1)).isSelected()).thenReturn((Object)true);
        Mockito.when((Object)((ProviderTypeItemPresenter)this.presenter.getItemPresenters().get(selected1)).getProviderType()).thenReturn((Object)this.providerTypes.get(selected1));
        Mockito.when((Object)((ProviderTypeItemPresenter)this.presenter.getItemPresenters().get(selected2)).isSelected()).thenReturn((Object)true);
        Mockito.when((Object)((ProviderTypeItemPresenter)this.presenter.getItemPresenters().get(selected2)).getProviderType()).thenReturn((Object)this.providerTypes.get(selected2));
        this.presenter.isComplete(Assert::assertTrue);
        Collection selectedItems = this.presenter.getSelectedProviderTypes();
        Assert.assertEquals((Object)this.providerTypes.get(selected1), selectedItems.iterator().next());
        Assert.assertEquals((Object)this.providerTypes.get(selected1), selectedItems.iterator().next());
    }
}

