/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.AddNewProviderTypeEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeSelectedEvent;
import org.guvnor.ala.ui.client.navigation.ProviderTypeNavigationPresenter;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProviderTypeNavigationPresenterTest {
    private static final int PROVIDER_TYPE_SIZE = 5;
    @Mock
    private ProviderTypeNavigationPresenter.View view;
    @Mock
    private EventSourceMock<AddNewProviderTypeEvent> addNewProviderTypeEvent;
    @Mock
    private EventSourceMock<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;
    @Mock
    private EventSourceMock<ProviderTypeSelectedEvent> providerTypeSelectedEvent;
    private ProviderTypeNavigationPresenter presenter;
    private ProviderType providerType;
    private List<ProviderType> providerTypes;

    @Before
    public void setUp() {
        this.providerType = ProvisioningManagementTestCommons.mockProviderType((String)"0");
        this.providerTypes = ProvisioningManagementTestCommons.mockProviderTypeList((int)5);
        this.providerTypes.add(this.providerType);
        this.presenter = new ProviderTypeNavigationPresenter(this.view, this.addNewProviderTypeEvent, this.providerTypeListRefreshEvent, this.providerTypeSelectedEvent);
        this.presenter.init();
        ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        this.presenter.setup(this.providerType, this.providerTypes);
        ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        this.providerTypes.forEach(providerType -> ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addProviderType((ProviderTypeKey)ArgumentMatchers.eq((Object)providerType.getKey()), (String)ArgumentMatchers.eq((Object)UIUtil.getDisplayableProviderTypeName((ProviderType)providerType)), (Command)ArgumentMatchers.any(Command.class)));
    }

    @Test
    public void testOnSelect() {
        this.presenter.setup(this.providerType, this.providerTypes);
        this.providerTypes.forEach(currentProviderType -> {
            this.presenter.onSelect(new ProviderTypeSelectedEvent((ProviderTypeKey)currentProviderType.getKey()));
            if (!currentProviderType.equals((Object)this.providerType)) {
                ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).select((ProviderTypeKey)currentProviderType.getKey());
            }
        });
        ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).select((ProviderTypeKey)this.providerType.getKey());
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((ProviderTypeNavigationPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testOnRefresh() {
        this.presenter.onRefresh();
        ((EventSourceMock)Mockito.verify(this.providerTypeListRefreshEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeListRefreshEvent());
    }

    @Test
    public void testOnAddProviderType() {
        this.presenter.onAddProviderType();
        ((EventSourceMock)Mockito.verify(this.addNewProviderTypeEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(AddNewProviderTypeEvent.class));
    }
}

