/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation.providertype;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.navigation.providertype.ProviderTypePresenter;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.CustomGroupItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ProviderTypeView
implements IsElement,
ProviderTypePresenter.View {
    @DataField(value="current-provider-type-name")
    private Element providerType = DOM.createElement((String)"strong");
    @Inject
    @DataField(value="provider-list-group")
    private Div providersListGroup;
    @Inject
    private TranslationService translationService;
    @Inject
    private PopupHelper popupHelper;
    private ProviderTypePresenter presenter;
    private Map<String, CustomGroupItem> providerItems = new HashMap<String, CustomGroupItem>();
    private CustomGroupItem selected = null;

    public void init(ProviderTypePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.providersListGroup);
        this.providerItems.clear();
        this.selected = null;
        this.providerType.setInnerText("");
    }

    @Override
    public void setProviderTypeName(String providerTypeName) {
        this.providerType.setInnerText(providerTypeName);
    }

    @Override
    public void addProvider(String providerId, String providerName, Command onSelect) {
        if (this.providerItems.containsKey(providerId)) {
            return;
        }
        CustomGroupItem groupItem = CustomGroupItem.createAnchor(providerId, IconType.FOLDER_O, onSelect);
        this.providerItems.put(providerId, groupItem);
        this.providersListGroup.appendChild((Node)groupItem);
    }

    @Override
    public void select(String providerId) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        if (this.selected != null) {
            this.selected.setActive(false);
        }
        this.selected = this.providerItems.get(providerId);
        if (this.selected != null) {
            this.selected.setActive(true);
        }
    }

    @Override
    public void confirmRemove(Command command) {
        this.popupHelper.showYesNoPopup(this.getRemoveProviderTypePopupTitle(), this.getRemoveProviderTypePopupText(), command, () -> {});
    }

    @EventHandler(value={"add-new-provider"})
    private void onAddNewProvider(@ForEvent(value={"click"}) Event event) {
        this.presenter.onAddNewProvider();
    }

    @EventHandler(value={"remove-current-provider-type"})
    private void onRemoveProviderType(@ForEvent(value={"click"}) Event event) {
        this.presenter.onRemoveProviderType();
    }

    private String getRemoveProviderTypePopupTitle() {
        return this.translationService.format("ProviderTypeView.ProviderTypeDisablePopupTitle", new Object[0]);
    }

    private String getRemoveProviderTypePopupText() {
        return this.translationService.format("ProviderTypeView.ProviderTypeDisablePopupText", new Object[0]);
    }
}

