/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsChangeEvent;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPopup;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class ContainerConfigParamsPresenter
extends AbstractHasContentChangeHandlers
implements PipelineParamsForm {
    private final View view;
    private final ContainerConfigPopup containerConfigPopup;
    private final Event<ContainerConfigParamsChangeEvent> configParamsChangeEvent;
    private final TranslationService translationService;
    private ListDataProvider<ContainerConfig> dataProvider = this.createDataProvider();

    @Inject
    public ContainerConfigParamsPresenter(View view, ContainerConfigPopup containerConfigPopup, Event<ContainerConfigParamsChangeEvent> configParamsChangeEvent, TranslationService translationService) {
        this.view = view;
        this.containerConfigPopup = containerConfigPopup;
        this.configParamsChangeEvent = configParamsChangeEvent;
        this.translationService = translationService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.dataProvider.addDataDisplay(this.view.getDisplay());
    }

    @Override
    public IsElement getView() {
        return this.view;
    }

    @Override
    public Map<String, String> buildParams() {
        return new HashMap<String, String>();
    }

    @Override
    public void initialise() {
    }

    @Override
    public void prepareView() {
        this.dataProvider.refresh();
    }

    @Override
    public void clear() {
        this.dataProvider.getList().clear();
    }

    @Override
    public void isComplete(Callback<Boolean> callback) {
        boolean complete = !this.dataProvider.getList().isEmpty();
        callback.callback((Object)complete);
    }

    @Override
    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    protected void onAddContainer() {
        this.containerConfigPopup.show(this.translationService.getTranslation("ContainerConfigParamsPresenter.AddContainerPopupTitle"), (ParameterizedCommand<ContainerConfig>)((ParameterizedCommand)this::addContainer), () -> {}, this.getCurrentContainerNames());
    }

    protected void onDeleteContainer(ContainerConfig containerConfig) {
        this.dataProvider.getList().remove(containerConfig);
        this.onContentChange();
    }

    private void addContainer(ContainerConfig containerConfig) {
        this.dataProvider.getList().add(containerConfig);
        this.onContentChange();
    }

    private void onContentChange() {
        this.configParamsChangeEvent.fire((Object)new ContainerConfigParamsChangeEvent(new ArrayList<ContainerConfig>(this.dataProvider.getList())));
        this.fireChangeHandlers();
    }

    ListDataProvider<ContainerConfig> createDataProvider() {
        return new ListDataProvider();
    }

    private List<String> getCurrentContainerNames() {
        return this.dataProvider.getList().stream().map(ContainerConfig::getName).collect(Collectors.toList());
    }

    public static interface View
    extends UberElement<ContainerConfigParamsPresenter> {
        public String getWizardTitle();

        public HasData<ContainerConfig> getDisplay();
    }
}

