/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.validation.ProvisioningClientValidationService;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.artifact.ArtifactSelectorPresenter;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@Dependent
public class ContainerConfigPresenter {
    private final View view;
    private final ArtifactSelectorPresenter artifactSelector;
    private PopupHelper popupHelper;
    private TranslationService translationService;
    private final Caller<M2RepoService> m2RepoService;
    private final ProvisioningClientValidationService validationService;
    private List<String> alreadyInUseNames;
    boolean containerNameValid = false;

    @Inject
    public ContainerConfigPresenter(View view, ArtifactSelectorPresenter artifactSelector, TranslationService translationService, PopupHelper popupHelper, Caller<M2RepoService> m2RepoService, ProvisioningClientValidationService validationService) {
        this.view = view;
        this.artifactSelector = artifactSelector;
        this.popupHelper = popupHelper;
        this.translationService = translationService;
        this.m2RepoService = m2RepoService;
        this.validationService = validationService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.artifactSelector.setArtifactSelectHandler(this::onArtifactSelected);
        this.view.setArtifactSelectorPresenter((IsElement)this.artifactSelector.getView());
    }

    public IsElement getView() {
        return this.view;
    }

    public void clear() {
        this.artifactSelector.clear();
        this.view.clear();
        this.containerNameValid = false;
    }

    public void setup(List<String> alreadyInUseNames) {
        this.alreadyInUseNames = new ArrayList<String>(alreadyInUseNames);
    }

    public boolean validateForSubmit() {
        boolean isValid;
        boolean bl = isValid = this.isValidContainerName() && this.isValidGroupId() && this.isValidArtifactId() && this.isValidVersion();
        if (!isValid) {
            this.view.showFormError(this.translationService.getTranslation("ContainerConfigPresenter.AllFieldsMustBeCompletedErrorMessage"));
        } else {
            this.view.clearFormError();
        }
        return isValid;
    }

    public ContainerConfig getContainerConfig() {
        return new ContainerConfig(this.getContainerName(), this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    private String getContainerName() {
        return this.view.getContainerName();
    }

    private String getGroupId() {
        return UIUtil.trimOrGetEmpty(this.view.getGroupId());
    }

    private String getArtifactId() {
        return UIUtil.trimOrGetEmpty(this.view.getArtifactId());
    }

    private String getVersion() {
        return UIUtil.trimOrGetEmpty(this.view.getVersion());
    }

    private boolean isValidContainerName() {
        return this.containerNameValid;
    }

    private boolean isAlreadyInUse(String containerName) {
        return this.alreadyInUseNames != null && this.alreadyInUseNames.contains(containerName);
    }

    private boolean isValidGroupId() {
        return !this.getGroupId().isEmpty();
    }

    private boolean isValidArtifactId() {
        return !this.getArtifactId().isEmpty();
    }

    private boolean isValidVersion() {
        return !this.getVersion().isEmpty();
    }

    protected void onArtifactSelected(String path) {
        this.view.clearFormError();
        ((M2RepoService)this.m2RepoService.call(this.getLoadGAVSuccessCallback(), this.getLoadGAVErrorCallback())).loadGAVFromJar(path);
    }

    protected void onContainerNameChange() {
        this.view.clearContainerNameHelpText();
        this.view.clearFormError();
        this.validationService.isValidContainerName(this.getContainerName(), new ValidatorCallback(){

            public void onSuccess() {
                ContainerConfigPresenter.this.view.setContainerNameStatus(FormStatus.VALID);
                ContainerConfigPresenter.this.containerNameValid = true;
                if (ContainerConfigPresenter.this.isAlreadyInUse(ContainerConfigPresenter.this.getContainerName())) {
                    ContainerConfigPresenter.this.containerNameValid = false;
                    ContainerConfigPresenter.this.view.setContainerNameHelpText(ContainerConfigPresenter.this.translationService.getTranslation("ContainerConfigPresenter.ContainerNameAlreadyInUseErrorMessage"));
                    ContainerConfigPresenter.this.view.setContainerNameStatus(FormStatus.ERROR);
                }
            }

            public void onFailure() {
                ContainerConfigPresenter.this.view.setContainerNameStatus(FormStatus.ERROR);
                ContainerConfigPresenter.this.containerNameValid = false;
                ContainerConfigPresenter.this.view.setContainerNameHelpText(ContainerConfigPresenter.this.translationService.getTranslation("ContainerConfigPresenter.InvalidContainerNameErrorMessage"));
            }
        });
    }

    protected void onGroupIdChange() {
        if (this.isValidGroupId()) {
            this.view.setGroupIdStatus(FormStatus.VALID);
        } else {
            this.view.setGroupIdStatus(FormStatus.ERROR);
        }
        this.view.clearFormError();
    }

    protected void onArtifactIdChange() {
        if (this.isValidArtifactId()) {
            this.view.setArtifactIdStatus(FormStatus.VALID);
        } else {
            this.view.setArtifactIdStatus(FormStatus.ERROR);
        }
        this.view.clearFormError();
    }

    protected void onVersionChange() {
        if (this.isValidVersion()) {
            this.view.setVersionStatus(FormStatus.VALID);
        } else {
            this.view.setVersionStatus(FormStatus.ERROR);
        }
        this.view.clearFormError();
    }

    private RemoteCallback<GAV> getLoadGAVSuccessCallback() {
        return gav -> {
            this.view.setGroupId(gav.getGroupId());
            this.view.setArtifactId(gav.getArtifactId());
            this.view.setVersion(gav.getVersion());
            this.onGroupIdChange();
            this.onArtifactIdChange();
            this.onVersionChange();
        };
    }

    private ErrorCallback<Message> getLoadGAVErrorCallback() {
        return (message, throwable) -> {
            this.view.setGroupId("");
            this.view.setArtifactId("");
            this.view.setVersion("");
            this.popupHelper.showErrorPopup(this.translationService.format("ContainerConfigPresenter.LoadGAVErrorMessage", new Object[]{throwable.getMessage()}));
            return false;
        };
    }

    public static interface View
    extends UberElement<ContainerConfigPresenter> {
        public String getContainerName();

        public void setContainerName(String var1);

        public String getGroupId();

        public void setGroupId(String var1);

        public String getArtifactId();

        public void setArtifactId(String var1);

        public String getVersion();

        public void setVersion(String var1);

        public void setArtifactSelectorPresenter(IsElement var1);

        public void clear();

        public void setContainerNameStatus(FormStatus var1);

        public void setGroupIdStatus(FormStatus var1);

        public void setArtifactIdStatus(FormStatus var1);

        public void setVersionStatus(FormStatus var1);

        public void setContainerNameHelpText(String var1);

        public void clearContainerNameHelpText();

        public void showFormError(String var1);

        public void clearFormError();
    }
}

