/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.pipeline.select;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.wizard.pipeline.select.item.PipelineItemPresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

public class SelectPipelinePagePresenter
implements WizardPage {
    private final View view;
    private final Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private final ManagedInstance<PipelineItemPresenter> itemPresenterInstance;
    private List<PipelineItemPresenter> itemPresenters = new ArrayList<PipelineItemPresenter>();

    @Inject
    public SelectPipelinePagePresenter(View view, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent, ManagedInstance<PipelineItemPresenter> itemPresenterInstance) {
        this.view = view;
        this.wizardPageStatusChangeEvent = wizardPageStatusChangeEvent;
        this.itemPresenterInstance = itemPresenterInstance;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(Collection<PipelineKey> pipelines) {
        this.clear();
        pipelines.forEach(pipeline -> {
            PipelineItemPresenter presenter = this.newItemPresenter();
            presenter.setup((PipelineKey)pipeline);
            presenter.addContentChangeHandler(this::onContentChange);
            this.itemPresenters.add(presenter);
            this.view.addPipelineItem(presenter.getView());
        });
        this.itemPresenters.forEach(item -> item.addOthers(this.itemPresenters));
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public void isComplete(Callback<Boolean> callback) {
        for (PipelineItemPresenter item : this.itemPresenters) {
            if (!item.isSelected()) continue;
            callback.callback((Object)true);
            return;
        }
        callback.callback((Object)false);
    }

    public void clear() {
        this.view.clear();
        this.clearItemPresenters();
    }

    public String getTitle() {
        return this.view.getTitle();
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public PipelineKey getPipeline() {
        return this.itemPresenters.stream().filter(PipelineItemPresenter::isSelected).map(PipelineItemPresenter::getPipeline).findFirst().orElse(null);
    }

    private void onContentChange() {
        this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
    }

    protected PipelineItemPresenter newItemPresenter() {
        return (PipelineItemPresenter)this.itemPresenterInstance.get();
    }

    protected List<PipelineItemPresenter> getItemPresenters() {
        return this.itemPresenters;
    }

    private void clearItemPresenters() {
        this.itemPresenters.forEach(arg_0 -> this.itemPresenterInstance.destroy(arg_0));
        this.itemPresenters.clear();
    }

    public static interface View
    extends UberElement<SelectPipelinePagePresenter> {
        public void clear();

        public void addPipelineItem(IsElement var1);

        public String getTitle();
    }
}

