/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.pipeline.select.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.model.PipelineKey;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class PipelineItemPresenter
extends AbstractHasContentChangeHandlers {
    private final View view;
    private final Collection<PipelineItemPresenter> others = new ArrayList<PipelineItemPresenter>();
    private PipelineKey pipeline;

    @Inject
    public PipelineItemPresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(PipelineKey pipeline) {
        this.pipeline = pipeline;
        this.view.setPipelineName(pipeline.getId());
    }

    public PipelineKey getPipeline() {
        return this.pipeline;
    }

    public void addOthers(Collection<PipelineItemPresenter> items) {
        this.others.addAll(items.stream().filter(other -> !other.equals(this)).collect(Collectors.toList()));
    }

    public boolean isSelected() {
        return this.view.isSelected();
    }

    public IsElement getView() {
        return this.view;
    }

    protected void onItemClick() {
        this.view.setSelected(!this.view.isSelected());
        if (this.view.isSelected()) {
            this.unSelectOthers();
        }
        this.fireChangeHandlers();
    }

    private void unSelectOthers() {
        this.others.forEach(PipelineItemPresenter::unSelect);
    }

    private void unSelect() {
        this.view.setSelected(false);
    }

    public static interface View
    extends UberElement<PipelineItemPresenter> {
        public boolean isSelected();

        public void setSelected(boolean var1);

        public void setPipelineName(String var1);
    }
}

