/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.spaces.Space;

@ApplicationScoped
public class SourceConfigurationParamsPresenter
extends AbstractHasContentChangeHandlers
implements PipelineParamsForm {
    public static final String REPO_NAME = "repo-name";
    public static final String BRANCH = "branch";
    public static final String MODULE_DIR = "module-dir";
    private final View view;
    private final Caller<SourceService> sourceService;
    private final Map<String, Module> currentModules = new HashMap<String, Module>();

    @Inject
    public SourceConfigurationParamsPresenter(View view, Caller<SourceService> sourceService) {
        this.view = view;
        this.sourceService = sourceService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Override
    public IsElement getView() {
        return this.view;
    }

    @Override
    public String getWizardTitle() {
        return this.view.getTitle();
    }

    @Override
    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)this.isValid());
    }

    @Override
    public void initialise() {
        this.setup();
    }

    @Override
    public void prepareView() {
    }

    @Override
    public Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("runtime-name", this.getRuntime());
        params.put(REPO_NAME, this.getSpace().getName() + "/" + this.getRepository());
        params.put(BRANCH, this.getBranch());
        params.put(MODULE_DIR, this.getModule().getModuleName());
        return params;
    }

    @Override
    public void clear() {
        this.view.clear();
        this.clearModules();
    }

    private void setup() {
        this.loadOUs();
    }

    private String getRuntime() {
        return UIUtil.trimOrGetEmpty(this.view.getRuntimeName());
    }

    private String getBranch() {
        return this.view.getBranch();
    }

    private String getRepository() {
        return this.view.getRepository();
    }

    private String getOU() {
        return this.view.getOU();
    }

    private Module getModule() {
        return this.currentModules.get(this.view.getModule());
    }

    private boolean isValid() {
        return !this.getRuntime().isEmpty() && !this.getOU().isEmpty() && !this.getRepository().isEmpty() && !this.getBranch().isEmpty() && this.getModule() != null;
    }

    public void disable() {
        this.view.disable();
    }

    protected void onRuntimeNameChange() {
        if (!this.getRuntime().isEmpty()) {
            this.view.setRuntimeStatus(FormStatus.VALID);
        } else {
            this.view.setRuntimeStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onOrganizationalUnitChange() {
        if (!this.view.getOU().isEmpty()) {
            this.view.setOUStatus(FormStatus.VALID);
            this.view.clearRepositories();
            this.view.clearBranches();
            this.clearModules();
            this.loadRepositories(this.getOU());
        } else {
            this.view.setOUStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onRepositoryChange() {
        if (!this.view.getRepository().isEmpty()) {
            this.view.setRepositoryStatus(FormStatus.VALID);
            this.view.clearBranches();
            this.clearModules();
            this.loadBranches(this.getSpace(), this.getRepository());
        } else {
            this.view.setRepositoryStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onBranchChange() {
        if (!this.view.getBranch().isEmpty()) {
            this.view.setBranchStatus(FormStatus.VALID);
            this.clearModules();
            this.loadProjects(this.getSpace(), this.getRepository(), this.getBranch());
        } else {
            this.view.setBranchStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private Space getSpace() {
        return new Space(this.view.getOU());
    }

    protected void onModuleChange() {
        if (!this.view.getModule().isEmpty()) {
            this.view.setProjectStatus(FormStatus.VALID);
        } else {
            this.view.setProjectStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private void loadOUs() {
        ((SourceService)this.sourceService.call(ous -> {
            this.view.clearOrganizationUnits();
            ous.forEach(this.view::addOrganizationUnit);
            this.view.clearRepositories();
            this.view.clearBranches();
            this.clearModules();
        })).getOrganizationUnits();
    }

    private void loadRepositories(String ou) {
        ((SourceService)this.sourceService.call(repos -> {
            this.view.clearRepositories();
            repos.forEach(this.view::addRepository);
            this.view.clearBranches();
            this.clearModules();
        })).getRepositories(ou);
    }

    private void loadBranches(Space space, String repository) {
        ((SourceService)this.sourceService.call(branches -> {
            this.view.clearBranches();
            branches.forEach(this.view::addBranch);
            this.clearModules();
        })).getBranches(space, repository);
    }

    private void loadProjects(Space space, String repository, String branch) {
        ((SourceService)this.sourceService.call(modules -> {
            this.clearModules();
            modules.forEach(module -> {
                this.view.addModule(module.getModuleName());
                this.currentModules.put(module.getModuleName(), (Module)module);
            });
        }, (ErrorCallback)new DefaultErrorCallback())).getModules(space, repository, branch);
    }

    private void clearModules() {
        this.view.clearModules();
        this.currentModules.clear();
    }

    private void onContentChange() {
        this.fireChangeHandlers();
    }

    public static interface View
    extends UberElement<SourceConfigurationParamsPresenter> {
        public String getRuntimeName();

        public String getOU();

        public String getRepository();

        public String getBranch();

        public String getModule();

        public void setRuntimeStatus(FormStatus var1);

        public void setOUStatus(FormStatus var1);

        public void setRepositoryStatus(FormStatus var1);

        public void setBranchStatus(FormStatus var1);

        public void setProjectStatus(FormStatus var1);

        public void clear();

        public void disable();

        public void enable();

        public String getTitle();

        public void clearRepositories();

        public void addRepository(String var1);

        public void clearBranches();

        public void addBranch(String var1);

        public void clearOrganizationUnits();

        public void addOrganizationUnit(String var1);

        public void clearModules();

        public void addModule(String var1);
    }
}

