/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationParamsPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class SourceConfigurationParamsView
implements IsElement,
SourceConfigurationParamsPresenter.View {
    @Inject
    @DataField(value="runtime-form")
    private Div runtimeForm;
    @Inject
    @DataField(value="runtime-name")
    private TextInput runtimeName;
    @Inject
    @DataField(value="ou-form")
    private Div ouForm;
    @Inject
    @DataField
    private Select ous;
    @Inject
    @DataField(value="repo-form")
    private Div repoForm;
    @Inject
    @DataField
    private Select repos;
    @Inject
    @DataField(value="branch-form")
    private Div branchForm;
    @Inject
    @DataField
    private Select branches;
    @Inject
    @DataField(value="module-form")
    private Div moduleForm;
    @Inject
    @DataField
    private Select modules;
    @Inject
    private TranslationService translationService;
    private SourceConfigurationParamsPresenter presenter;

    public void init(SourceConfigurationParamsPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getTitle() {
        return this.translationService.getTranslation("SourceConfigurationPageView.Title");
    }

    @Override
    public String getRuntimeName() {
        return this.runtimeName.getValue();
    }

    @Override
    public String getOU() {
        return this.ous.getValue();
    }

    @Override
    public String getRepository() {
        return this.repos.getValue();
    }

    @Override
    public String getBranch() {
        return this.branches.getValue();
    }

    @Override
    public String getModule() {
        return this.modules.getValue();
    }

    @Override
    public void disable() {
        this.resetFormState();
        this.enable(false);
    }

    @Override
    public void enable() {
        this.resetFormState();
        this.enable(true);
    }

    @Override
    public void setRuntimeStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.runtimeForm, status);
    }

    @Override
    public void setOUStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.ouForm, status);
    }

    @Override
    public void setRepositoryStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.repoForm, status);
    }

    @Override
    public void setBranchStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.branchForm, status);
    }

    @Override
    public void setProjectStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status));
        StyleHelper.setFormStatus((HTMLElement)this.moduleForm, status);
    }

    @Override
    public void clear() {
        this.resetFormState();
        this.clearOrganizationUnits();
        this.clearRepositories();
        this.clearBranches();
        this.clearModules();
        this.runtimeName.setValue("");
        this.ous.setValue("");
        this.repos.setValue("");
        this.branches.setValue("");
        this.modules.setValue("");
    }

    @Override
    public void addOrganizationUnit(String ou) {
        this.ous.add((HTMLElement)this.newOption(ou, ou));
    }

    @Override
    public void addRepository(String repo) {
        this.repos.add((HTMLElement)this.newOption(repo, repo));
    }

    @Override
    public void addBranch(String branch) {
        this.branches.add((HTMLElement)this.newOption(branch, branch));
    }

    @Override
    public void addModule(String moduleName) {
        this.modules.add((HTMLElement)this.newOption(moduleName, moduleName));
    }

    @Override
    public void clearOrganizationUnits() {
        this.clear(this.ous);
    }

    @Override
    public void clearRepositories() {
        this.clear(this.repos);
    }

    @Override
    public void clearBranches() {
        this.clear(this.branches);
    }

    @Override
    public void clearModules() {
        this.clear(this.modules);
    }

    @EventHandler(value={"runtime-name"})
    private void onRuntimeChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onRuntimeNameChange();
    }

    @EventHandler(value={"ous"})
    private void onOrganizationalUnitChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onOrganizationalUnitChange();
    }

    @EventHandler(value={"repos"})
    private void onRepositoryChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onRepositoryChange();
    }

    @EventHandler(value={"branches"})
    private void onBranchChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onBranchChange();
    }

    @EventHandler(value={"modules"})
    private void onProjectChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onModuleChange();
    }

    private void enable(boolean enabled) {
        this.runtimeName.setDisabled(!enabled);
        this.ous.setDisabled(!enabled);
        this.repos.setDisabled(!enabled);
        this.branches.setDisabled(!enabled);
        this.modules.setDisabled(!enabled);
    }

    private void resetFormState() {
        StyleHelper.setFormStatus((HTMLElement)this.runtimeForm, FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.ouForm, FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.repoForm, FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.branchForm, FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.moduleForm, FormStatus.VALID);
    }

    private Option newOption(String text, String value) {
        Option option = (Option)Window.getDocument().createElement("option");
        option.setTextContent(text);
        option.setValue(value);
        return option;
    }

    private HTMLElement defaultOption() {
        HTMLElement option = Window.getDocument().createElement("option");
        option.setAttribute("value", "");
        option.setAttribute("disabled", "");
        option.setAttribute("selected", "");
        option.setTextContent(this.translationService.getTranslation("SourceConfigurationPageView.SelectOption-placeholder"));
        return option;
    }

    private void clear(Select select) {
        for (int i = 0; i < select.getOptions().getLength(); ++i) {
            select.remove(i);
        }
        select.setInnerHTML("");
        select.add(this.defaultOption(), null);
    }
}

