/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.wizard.EnableProviderTypeWizard;
import org.guvnor.ala.ui.client.wizard.WizardBaseTest;
import org.guvnor.ala.ui.client.wizard.providertype.EnableProviderTypePagePresenter;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class EnableProviderTypeWizardTest
extends WizardBaseTest {
    @Mock
    private EnableProviderTypePagePresenter enableProviderTypePage;
    @Mock
    private ProviderTypeService providerTypeService;
    private Caller<ProviderTypeService> providerTypeServiceCaller;
    @Mock
    private EventSourceMock<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;
    private EnableProviderTypeWizard wizard;
    private List<ProviderType> providerTypes;
    private List<Pair<ProviderType, ProviderTypeStatus>> providerTypeStatus;
    private List<ProviderType> selectedProviders;

    @Before
    public void setUp() {
        this.providerTypes = ProvisioningManagementTestCommons.mockProviderTypeList((int)3);
        this.providerTypeStatus = ProvisioningManagementTestCommons.buildProviderTypeStatusList(this.providerTypes, (ProviderTypeStatus)ProviderTypeStatus.DISABLED);
        Mockito.when((Object)this.translationService.getTranslation("EnableProviderTypeWizard.ProviderTypeEnableSuccessMessage")).thenReturn((Object)"SUCCESS_MESSAGE");
        Mockito.when((Object)this.translationService.getTranslation("EnableProviderTypeWizard.ProviderTypeEnableErrorMessage")).thenReturn((Object)"ERROR_MESSAGE");
        this.providerTypeServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.providerTypeService));
        this.wizard = new EnableProviderTypeWizard(this.enableProviderTypePage, this.translationService, (Caller)this.providerTypeServiceCaller, (Event)this.notification, (Event)this.providerTypeListRefreshEvent){
            {
                this.view = EnableProviderTypeWizardTest.this.wizardView;
            }
        };
        this.wizard.init();
    }

    @Test
    public void testEnableProviderSuccess() {
        this.wizard.start(this.providerTypeStatus);
        this.preCompleteWizard();
        this.wizard.complete();
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).enableProviderTypes(this.selectedProviders);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("SUCCESS_MESSAGE", NotificationEvent.NotificationType.SUCCESS));
        ((EventSourceMock)Mockito.verify(this.providerTypeListRefreshEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeListRefreshEvent((ProviderTypeKey)this.selectedProviders.get(0).getKey()));
    }

    @Test
    public void testEnableProviderFailure() {
        this.wizard.start(this.providerTypeStatus);
        this.preCompleteWizard();
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.providerTypeService, this.providerTypeServiceCaller);
        this.wizard.complete();
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).enableProviderTypes(this.selectedProviders);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("ERROR_MESSAGE", NotificationEvent.NotificationType.ERROR));
    }

    private void preCompleteWizard() {
        int selectedIndex1 = 1;
        int selectedIndex2 = 2;
        this.selectedProviders = new ArrayList<ProviderType>();
        this.selectedProviders.add(this.providerTypes.get(selectedIndex1));
        this.selectedProviders.add(this.providerTypes.get(selectedIndex2));
        Mockito.when((Object)this.enableProviderTypePage.getSelectedProviderTypes()).thenReturn(this.selectedProviders);
        this.preparePageCompletion((WizardPage)this.enableProviderTypePage);
        this.wizard.isComplete(Assert::assertTrue);
    }
}

