/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.AddNewProviderEvent;
import org.guvnor.ala.ui.client.events.AddNewProviderTypeEvent;
import org.guvnor.ala.ui.client.events.AddNewRuntimeEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.wizard.EnableProviderTypeWizard;
import org.guvnor.ala.ui.client.wizard.NewDeployWizard;
import org.guvnor.ala.ui.client.wizard.NewProviderWizard;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="ProvisioningManagementPerspective")
public class ProvisioningManagementPerspective {
    public static final String IDENTIFIER = "ProvisioningManagementPerspective";
    private final Caller<ProviderTypeService> providerTypeService;
    private final Caller<RuntimeService> runtimeService;
    private final EnableProviderTypeWizard enableProviderTypeWizard;
    private final NewProviderWizard newProviderWizard;
    private final NewDeployWizard newDeployWizard;
    private final ClientProviderHandlerRegistry handlerRegistry;

    @Inject
    public ProvisioningManagementPerspective(Caller<ProviderTypeService> providerTypeService, Caller<RuntimeService> runtimeService, EnableProviderTypeWizard enableProviderTypeWizard, NewProviderWizard newProviderWizard, NewDeployWizard newDeployWizard, ClientProviderHandlerRegistry handlerRegistry) {
        this.providerTypeService = providerTypeService;
        this.runtimeService = runtimeService;
        this.enableProviderTypeWizard = enableProviderTypeWizard;
        this.newProviderWizard = newProviderWizard;
        this.newDeployWizard = newDeployWizard;
        this.handlerRegistry = handlerRegistry;
    }

    @Perspective
    public PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(StaticWorkbenchPanelPresenter.class.getName());
        perspective.setName(IDENTIFIER);
        perspective.getRoot().addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("ProvisioningManagementBrowser")));
        return perspective;
    }

    protected void onAddNewProviderType(@Observes AddNewProviderTypeEvent event) {
        ((ProviderTypeService)this.providerTypeService.call(result -> this.enableProviderTypeWizard.start(this.buildProviderStatusList((Map<ProviderType, ProviderTypeStatus>)result)))).getProviderTypesStatus();
    }

    protected void onAddNewProvider(@Observes AddNewProviderEvent event) {
        if (event.getProviderType() != null && event.getProviderType().getKey() != null) {
            this.newProviderWizard.start(event.getProviderType());
        }
    }

    protected void onAddNewRuntime(@Observes AddNewRuntimeEvent event) {
        if (event.getProvider() != null) {
            ((RuntimeService)this.runtimeService.call(result -> this.newDeployWizard.start(event.getProvider(), (Collection<PipelineKey>)result))).getPipelines(((ProviderKey)event.getProvider().getKey()).getProviderTypeKey());
        }
    }

    private List<Pair<ProviderType, ProviderTypeStatus>> buildProviderStatusList(Map<ProviderType, ProviderTypeStatus> statusMap) {
        return statusMap.entrySet().stream().filter(entry -> this.handlerRegistry.isProviderInstalled((ProviderTypeKey)((ProviderType)entry.getKey()).getKey())).map(entry -> new Pair((Object)((ProviderType)entry.getKey()), (Object)((ProviderTypeStatus)entry.getValue()))).sorted(Comparator.comparing(o -> ((ProviderType)o.getK1()).getName())).collect(Collectors.toList());
    }
}

