/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation.providertype;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.events.AddNewProviderEvent;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class ProviderTypePresenter {
    private final View view;
    private final Caller<ProviderTypeService> providerTypeService;
    private final Event<AddNewProviderEvent> addNewProviderEvent;
    private final Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;
    private final Event<ProviderSelectedEvent> providerSelectedEvent;
    private ProviderType providerType;

    @Inject
    public ProviderTypePresenter(View view, Caller<ProviderTypeService> providerTypeService, Event<AddNewProviderEvent> addNewProviderEvent, Event<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent, Event<ProviderSelectedEvent> providerSelectedEvent) {
        this.view = view;
        this.providerTypeService = providerTypeService;
        this.addNewProviderEvent = addNewProviderEvent;
        this.providerTypeListRefreshEvent = providerTypeListRefreshEvent;
        this.providerSelectedEvent = providerSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(ProviderType providerType, Collection<ProviderKey> providers, ProviderKey firstProviderKey) {
        this.view.clear();
        this.providerType = providerType;
        this.view.setProviderTypeName(UIUtil.getDisplayableProviderTypeName(providerType));
        if (firstProviderKey != null) {
            this.addProvider(firstProviderKey);
            providers.stream().filter(providerKey -> !providerKey.equals((Object)firstProviderKey)).forEach(this::addProvider);
            this.selectProvider(firstProviderKey);
        }
    }

    private void addProvider(ProviderKey providerKey) {
        this.view.addProvider(providerKey.getId(), providerKey.getId(), () -> this.selectProvider(providerKey));
    }

    private void selectProvider(ProviderKey providerKey) {
        this.providerSelectedEvent.fire((Object)new ProviderSelectedEvent(providerKey));
    }

    public void onProviderSelect(@Observes ProviderSelectedEvent event) {
        if (event.getProviderKey() != null && event.getProviderKey().getId() != null && event.getProviderKey().getProviderTypeKey() != null && event.getProviderKey().getProviderTypeKey().equals(this.providerType.getKey())) {
            this.view.select(event.getProviderKey().getId());
        }
    }

    public void onAddNewProvider() {
        this.addNewProviderEvent.fire((Object)new AddNewProviderEvent(this.providerType));
    }

    public void onRemoveProviderType() {
        this.view.confirmRemove(this::removeProviderType);
    }

    protected void removeProviderType() {
        ((ProviderTypeService)this.providerTypeService.call(aVoid -> this.providerTypeListRefreshEvent.fire((Object)new ProviderTypeListRefreshEvent()))).disableProviderType(this.providerType);
    }

    public static interface View
    extends UberElement<ProviderTypePresenter> {
        public void clear();

        public void setProviderTypeName(String var1);

        public void select(String var1);

        public void addProvider(String var1, String var2, Command var3);

        public void confirmRemove(Command var1);
    }
}

