/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.provider.ProviderPresenter;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ProviderView
implements IsElement,
ProviderPresenter.View {
    @Inject
    @DataField(value="provider-name")
    private Span providerName;
    @Inject
    @DataField(value="status-tab")
    private ListItem statusTab;
    @Inject
    @DataField(value="status-tab-link")
    private Anchor statusTabLink;
    @Inject
    @DataField(value="config-tab")
    private ListItem configTab;
    @Inject
    @DataField(value="config-tab-link")
    private Anchor configTabLink;
    @Inject
    @DataField(value="status-pane")
    private Div statusPane;
    @Inject
    @DataField(value="status-content")
    private Div statusContent;
    @Inject
    @DataField(value="config-pane")
    private Div rulesPane;
    @Inject
    @DataField(value="config-content")
    private Div configContent;
    @Inject
    private TranslationService translationService;
    @Inject
    private PopupHelper popupHelper;
    private ProviderPresenter presenter;

    public void init(ProviderPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void confirmRemove(Command command) {
        this.popupHelper.showYesNoPopup(this.translationService.getTranslation("ProviderView.ConfirmRemovePopupTitle"), this.translationService.getTranslation("ProviderView.ConfirmRemovePopupMessage"), command, () -> {});
    }

    @Override
    public void showProviderCantBeDeleted() {
        this.popupHelper.showInformationPopup(this.translationService.getTranslation("ProviderView.ProviderCantBeDeletedMessage"));
    }

    @Override
    public void setProviderName(String name) {
        this.providerName.setTextContent(name);
    }

    @Override
    public void setStatus(org.jboss.errai.common.client.api.IsElement view) {
        DOMUtil.removeAllChildren((Node)this.statusContent);
        this.statusContent.appendChild((Node)view.getElement());
    }

    @Override
    public void setConfig(org.jboss.errai.common.client.api.IsElement view) {
        DOMUtil.removeAllChildren((Node)this.configContent);
        this.configContent.appendChild((Node)view.getElement());
    }

    @Override
    public String getRemoveProviderSuccessMessage() {
        return this.translationService.getTranslation("ProviderView.RemoveProviderSuccessMessage");
    }

    @Override
    public String getRemoveProviderErrorMessage() {
        return this.translationService.getTranslation("ProviderView.RemoveProviderErrorMessage");
    }

    @EventHandler(value={"refresh-provider"})
    public void onRefresh(@ForEvent(value={"click"}) Event event) {
        this.presenter.refresh();
    }

    @EventHandler(value={"remove-provider"})
    public void onRemove(@ForEvent(value={"click"}) Event event) {
        this.presenter.onRemoveProvider();
    }

    @EventHandler(value={"deploy"})
    public void onDeploy(@ForEvent(value={"click"}) Event event) {
        this.presenter.deploy();
    }
}

