/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class ProviderStatusPresenter {
    private final View view;
    private final ManagedInstance<RuntimePresenter> runtimePresenterInstance;
    private final List<RuntimePresenter> currentItems = new ArrayList<RuntimePresenter>();

    @Inject
    public ProviderStatusPresenter(View view, ManagedInstance<RuntimePresenter> runtimePresenterInstance) {
        this.view = view;
        this.runtimePresenterInstance = runtimePresenterInstance;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setupItems(Collection<RuntimeListItem> response) {
        this.clear();
        response.forEach(item -> {
            RuntimePresenter runtimePresenter = this.newRuntimePresenter();
            runtimePresenter.setup((RuntimeListItem)item);
            this.currentItems.add(runtimePresenter);
            this.view.addListItem((IsElement)runtimePresenter.getView());
        });
    }

    public boolean removeItem(RuntimeKey runtimeKey) {
        Optional<RuntimePresenter> value = this.currentItems.stream().filter(presenter -> presenter.getItem().isRuntime() && runtimeKey.equals(presenter.getItem().getRuntime().getKey())).findFirst();
        value.ifPresent(this::removeItem);
        return value.isPresent();
    }

    public boolean removeItem(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        Optional<RuntimePresenter> value = this.currentItems.stream().filter(presenter -> !presenter.getItem().isRuntime() && presenter.getItem().getPipelineTrace() != null && pipelineExecutionTraceKey.equals(presenter.getItem().getPipelineTrace().getKey())).findFirst();
        value.ifPresent(this::removeItem);
        return value.isPresent();
    }

    public boolean isEmpty() {
        return this.currentItems.isEmpty();
    }

    public void clear() {
        this.view.clear();
        this.clearItems();
    }

    public View getView() {
        return this.view;
    }

    private void removeItem(RuntimePresenter item) {
        this.view.removeListItem((IsElement)item.getView());
        this.currentItems.remove(item);
        this.runtimePresenterInstance.destroy((Object)item);
    }

    protected RuntimePresenter newRuntimePresenter() {
        return (RuntimePresenter)this.runtimePresenterInstance.get();
    }

    private void clearItems() {
        this.currentItems.forEach(arg_0 -> this.runtimePresenterInstance.destroy(arg_0));
        this.currentItems.clear();
    }

    public static interface View
    extends UberElement<ProviderStatusPresenter> {
        public void addListItem(IsElement var1);

        public void removeListItem(IsElement var1);

        public void clear();
    }
}

