/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterHelper;
import org.guvnor.ala.ui.client.provider.status.runtime.actions.RuntimeActionItemPresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.actions.RuntimeActionItemSeparatorPresenter;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.pipeline.PipelinePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.transition.TransitionPresenter;
import org.guvnor.ala.ui.events.PipelineExecutionChangeEvent;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.RuntimeChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineError;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.RuntimeStatus;
import org.guvnor.ala.ui.model.Stage;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class RuntimePresenter {
    private static final String SYSTEM_PIPELINE_NAME = "<system>";
    private final View view;
    private final PipelinePresenter pipelinePresenter;
    private final ManagedInstance<StagePresenter> stagePresenterInstance;
    private final ManagedInstance<TransitionPresenter> transitionPresenterInstance;
    private final ManagedInstance<RuntimeActionItemPresenter> actionItemPresenterInstance;
    private final ManagedInstance<RuntimeActionItemSeparatorPresenter> actionItemSeparatorPresenterInstance;
    private final Caller<RuntimeService> runtimeService;
    protected Event<NotificationEvent> notification;
    private final PopupHelper popupHelper;
    private final TranslationService translationService;
    private final List<Stage> currentStages = new ArrayList<Stage>();
    private final Map<Stage, StagePresenter> stagePresenters = new HashMap<Stage, StagePresenter>();
    private final List<TransitionPresenter> currentTransitions = new ArrayList<TransitionPresenter>();
    private RuntimeListItem item;
    private RuntimeActionItemPresenter startAction;
    private RuntimeActionItemPresenter stopAction;
    private RuntimeActionItemPresenter deleteAction;
    private RuntimeActionItemSeparatorPresenter separator;
    private RuntimeActionItemSeparatorPresenter secondarySeparator;
    private RuntimeActionItemPresenter showErrorAction;

    @Inject
    public RuntimePresenter(View view, PipelinePresenter pipelinePresenter, ManagedInstance<StagePresenter> stagePresenterInstance, ManagedInstance<TransitionPresenter> transitionPresenterInstance, ManagedInstance<RuntimeActionItemPresenter> actionItemPresenterInstance, ManagedInstance<RuntimeActionItemSeparatorPresenter> actionItemSeparatorPresenterInstance, Caller<RuntimeService> runtimeService, Event<NotificationEvent> notification, PopupHelper popupHelper, TranslationService translationService) {
        this.view = view;
        this.pipelinePresenter = pipelinePresenter;
        this.stagePresenterInstance = stagePresenterInstance;
        this.transitionPresenterInstance = transitionPresenterInstance;
        this.actionItemPresenterInstance = actionItemPresenterInstance;
        this.actionItemSeparatorPresenterInstance = actionItemSeparatorPresenterInstance;
        this.runtimeService = runtimeService;
        this.notification = notification;
        this.popupHelper = popupHelper;
        this.translationService = translationService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.startAction = this.newActionItemPresenter();
        this.stopAction = this.newActionItemPresenter();
        this.deleteAction = this.newActionItemPresenter();
        this.separator = this.newSeparatorItem();
        this.secondarySeparator = this.newSeparatorItem();
        this.showErrorAction = this.newActionItemPresenter();
    }

    @PreDestroy
    public void destroy() {
        this.clearPipeline();
        this.actionItemPresenterInstance.destroy((Object)this.startAction);
        this.actionItemPresenterInstance.destroy((Object)this.stopAction);
        this.actionItemPresenterInstance.destroy((Object)this.deleteAction);
        this.actionItemSeparatorPresenterInstance.destroy((Object)this.separator);
        this.actionItemSeparatorPresenterInstance.destroy((Object)this.secondarySeparator);
        this.actionItemPresenterInstance.destroy((Object)this.showErrorAction);
    }

    public View getView() {
        return this.view;
    }

    public void setup(RuntimeListItem runtimeListItem) {
        this.item = runtimeListItem;
        this.clearPipeline();
        if (this.item.isRuntime()) {
            this.setupRuntime(runtimeListItem);
        } else {
            this.setupPipelineTrace(runtimeListItem);
        }
        this.view.addExpandedContent((IsElement)this.pipelinePresenter.getView());
    }

    public RuntimeListItem getItem() {
        return this.item;
    }

    private void setupRuntime(RuntimeListItem item) {
        String itemLabel = item.getItemLabel();
        String pipelineName = SYSTEM_PIPELINE_NAME;
        String createdDate = item.getRuntime().getCreatedDate();
        String endpoint = "";
        Runtime runtime = item.getRuntime();
        PipelineExecutionTrace trace = runtime.getPipelineTrace();
        if (trace != null) {
            pipelineName = ((PipelineKey)trace.getPipeline().getKey()).getId();
            this.setupPipeline(trace);
        }
        this.view.setup(itemLabel, createdDate, pipelineName);
        if (runtime.getEndpoint() != null) {
            endpoint = runtime.getEndpoint();
        }
        this.view.setEndpoint(endpoint);
        this.processRuntimeStatus(runtime);
    }

    private void setupPipelineTrace(RuntimeListItem item) {
        PipelineExecutionTrace trace = item.getPipelineTrace();
        String itemLabel = item.getItemLabel();
        String pipelineName = ((PipelineKey)trace.getPipeline().getKey()).getId();
        String createdDate = "";
        this.view.setup(itemLabel, createdDate, pipelineName);
        this.setupPipeline(trace);
        this.processPipelineStatus(trace.getPipelineStatus());
    }

    private void setupPipeline(PipelineExecutionTrace trace) {
        this.clearPipeline();
        boolean showStep = true;
        Pipeline pipeline = trace.getPipeline();
        for (int i = 0; showStep && i < pipeline.getStages().size(); ++i) {
            Stage stage = (Stage)pipeline.getStages().get(i);
            PipelineStatus stageStatus = trace.getStageStatus(stage.getName());
            showStep = this.showStage(stageStatus);
            if (!showStep) continue;
            if (i > 0) {
                TransitionPresenter transitionPresenter = this.newTransitionPresenter();
                this.currentTransitions.add(transitionPresenter);
                this.pipelinePresenter.addStage(transitionPresenter.getView());
            }
            StagePresenter stagePresenter = this.newStagePresenter();
            stagePresenter.setup(stage);
            stagePresenter.setState(RuntimePresenterHelper.buildStageState(stageStatus));
            this.pipelinePresenter.addStage((IsElement)stagePresenter.getView());
            this.currentStages.add(stage);
            this.stagePresenters.put(stage, stagePresenter);
        }
    }

    private boolean showStage(PipelineStatus stageStatus) {
        return stageStatus == PipelineStatus.RUNNING || stageStatus == PipelineStatus.FINISHED || stageStatus == PipelineStatus.ERROR || stageStatus == PipelineStatus.STOPPED;
    }

    private void processRuntimeStatus(Runtime runtime) {
        this.view.clearActionItems();
        this.enableActions(true, this.startAction, this.stopAction, this.deleteAction);
        this.view.addActionItem((IsElement)this.startAction.getView());
        this.view.addActionItem((IsElement)this.stopAction.getView());
        this.view.addActionItem((IsElement)this.separator.getView());
        this.view.addActionItem((IsElement)this.deleteAction.getView());
        this.startAction.setup(this.translationService.getTranslation("RuntimePresenter.RuntimeStartAction"), this::startRuntime);
        this.stopAction.setup(this.translationService.getTranslation("RuntimePresenter.RuntimeStopAction"), this::stopRuntime);
        this.deleteAction.setup(this.translationService.getTranslation("RuntimePresenter.RuntimeDeleteAction"), this::deleteRuntime);
        RuntimeStatus runtimeStatus = RuntimePresenterHelper.buildRuntimeStatus(runtime.getStatus());
        if (RuntimeStatus.RUNNING == runtimeStatus) {
            this.startAction.setEnabled(false);
        }
        if (RuntimeStatus.STOPPED == runtimeStatus || RuntimeStatus.READY == runtimeStatus) {
            this.stopAction.setEnabled(false);
        }
        this.view.setStatus(RuntimePresenterHelper.buildIconStyle(runtimeStatus));
        this.view.setStatusTitle(runtime.getStatus());
    }

    private void processPipelineStatus(PipelineStatus status) {
        this.view.clearActionItems();
        this.enableActions(false, this.startAction, this.stopAction, this.deleteAction, this.showErrorAction);
        this.view.addActionItem((IsElement)this.stopAction.getView());
        this.view.addActionItem((IsElement)this.separator.getView());
        this.view.addActionItem((IsElement)this.deleteAction.getView());
        this.stopAction.setup(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionStopAction"), this::stopPipeline);
        this.deleteAction.setup(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionDeleteAction"), this::deletePipeline);
        this.showErrorAction.setup(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionShowErrorAction"), this::showPipelineError);
        switch (status) {
            case SCHEDULED: 
            case RUNNING: {
                this.stopAction.setEnabled(true);
                break;
            }
            case STOPPED: {
                this.deleteAction.setEnabled(true);
                break;
            }
            case ERROR: {
                this.deleteAction.setEnabled(true);
                this.view.addActionItem((IsElement)this.secondarySeparator.getView());
                this.view.addActionItem((IsElement)this.showErrorAction.getView());
                this.showErrorAction.setEnabled(true);
                break;
            }
            case FINISHED: {
                if (this.item.getRuntime() != null) break;
                this.deleteAction.setEnabled(true);
            }
        }
        this.view.setStatus(RuntimePresenterHelper.buildIconStyle(status));
        this.view.setStatusTitle(status.name());
    }

    private void enableActions(boolean enabled, RuntimeActionItemPresenter ... actions) {
        Arrays.stream(actions).forEach(action -> action.setEnabled(enabled));
    }

    public void onStageStatusChange(@Observes StageStatusChangeEvent event) {
        if (this.isFromCurrentPipeline(event.getPipelineExecutionTraceKey())) {
            PipelineExecutionTrace trace = this.item.getPipelineTrace();
            Stage currentStage = this.currentStages.stream().filter(step -> event.getStage().equals(step.getName())).findFirst().orElse(null);
            if (currentStage != null) {
                StagePresenter stagePresenter = this.stagePresenters.get(currentStage);
                stagePresenter.setState(RuntimePresenterHelper.buildStageState(event.getStatus()));
            } else {
                Stage stage = new Stage((PipelineKey)this.item.getPipelineTrace().getPipeline().getKey(), event.getStage());
                PipelineStatus stageStatus = event.getStatus();
                StagePresenter stagePresenter = this.newStagePresenter();
                stagePresenter.setup(stage);
                stagePresenter.setState(RuntimePresenterHelper.buildStageState(stageStatus));
                if (!this.currentStages.isEmpty()) {
                    TransitionPresenter transitionPresenter = this.newTransitionPresenter();
                    this.currentTransitions.add(transitionPresenter);
                    this.pipelinePresenter.addStage(transitionPresenter.getView());
                }
                this.pipelinePresenter.addStage((IsElement)stagePresenter.getView());
                this.currentStages.add(stage);
                this.stagePresenters.put(stage, stagePresenter);
            }
            trace.setStageStatus(event.getStage(), event.getStatus());
        }
    }

    public void onPipelineStatusChange(@Observes PipelineStatusChangeEvent event) {
        if (this.isFromCurrentPipeline(event.getPipelineExecutionTraceKey())) {
            this.processPipelineStatus(event.getStatus());
            if (PipelineStatus.FINISHED.equals((Object)event.getStatus()) && !PipelineStatus.FINISHED.equals((Object)this.item.getPipelineTrace().getPipelineStatus()) || PipelineStatus.ERROR.equals((Object)event.getStatus())) {
                this.refresh(event.getPipelineExecutionTraceKey());
            }
        }
    }

    public void onPipelineExecutionChange(@Observes PipelineExecutionChangeEvent event) {
        if (event.isStop() && this.isFromCurrentPipeline(event.getPipelineExecutionTraceKey())) {
            this.refresh(event.getPipelineExecutionTraceKey());
        }
    }

    public void onRuntimeChangeEvent(@Observes RuntimeChangeEvent event) {
        if ((event.isStart() || event.isStop()) && this.isFromCurrentRuntime(event.getRuntimeKey())) {
            this.refresh(event.getRuntimeKey());
        }
    }

    protected void refresh(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        ((RuntimeService)this.runtimeService.call(this.getLoadItemSuccessCallback(), this.getDefaultErrorCallback())).getRuntimeItem(pipelineExecutionTraceKey);
    }

    protected void refresh(RuntimeKey runtimeKey) {
        ((RuntimeService)this.runtimeService.call(this.getLoadItemSuccessCallback(), this.getDefaultErrorCallback())).getRuntimeItem(runtimeKey);
    }

    private RemoteCallback<RuntimeListItem> getLoadItemSuccessCallback() {
        return runtimeListItem -> {
            if (runtimeListItem != null) {
                this.setup((RuntimeListItem)runtimeListItem);
            }
        };
    }

    protected void startRuntime() {
        this.popupHelper.showBusyIndicator(this.translationService.getTranslation("RuntimePresenter.RuntimeStartingMessage"));
        ((RuntimeService)this.runtimeService.call(this.getStartRuntimeSuccessCallback(), this.getDefaultErrorCallback(true))).startRuntime((RuntimeKey)this.item.getRuntime().getKey());
    }

    private RemoteCallback<Void> getStartRuntimeSuccessCallback() {
        return aVoid -> {
            this.popupHelper.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("RuntimePresenter.RuntimeStartSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()}), NotificationEvent.NotificationType.SUCCESS));
        };
    }

    protected void stopRuntime() {
        this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmStopTitle"), this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmStopMessage"), () -> {
            this.popupHelper.showBusyIndicator(this.translationService.getTranslation("RuntimePresenter.RuntimeStoppingMessage"));
            ((RuntimeService)this.runtimeService.call(this.getStopRuntimeSuccessCallback(), this.getDefaultErrorCallback(true))).stopRuntime((RuntimeKey)this.item.getRuntime().getKey());
        });
    }

    protected RemoteCallback<Void> getStopRuntimeSuccessCallback() {
        return aVoid -> {
            this.popupHelper.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("RuntimePresenter.RuntimeStopSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()}), NotificationEvent.NotificationType.SUCCESS));
        };
    }

    protected void deleteRuntime() {
        this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmDeleteTitle"), this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmDeleteMessage"), () -> {
            this.popupHelper.showBusyIndicator(this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingMessage"));
            ((RuntimeService)this.runtimeService.call(this.getDeleteRuntimeSuccessCallback(), this.getDeleteRuntimeErrorCallback())).deleteRuntime((RuntimeKey)this.item.getRuntime().getKey(), false);
        });
    }

    protected void forceDeleteRuntime() {
        this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteTitle"), this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteMessage"), () -> {
            this.popupHelper.showBusyIndicator(this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingForcedMessage"));
            ((RuntimeService)this.runtimeService.call(this.getDeleteRuntimeSuccessCallback(), this.getDefaultErrorCallback(true))).deleteRuntime((RuntimeKey)this.item.getRuntime().getKey(), true);
        });
    }

    private RemoteCallback<Void> getDeleteRuntimeSuccessCallback() {
        return aVoid -> {
            this.popupHelper.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("RuntimePresenter.RuntimeDeleteSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()}), NotificationEvent.NotificationType.SUCCESS));
        };
    }

    private ErrorCallback<Message> getDeleteRuntimeErrorCallback() {
        return (message, throwable) -> {
            this.popupHelper.hideBusyIndicator();
            this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.RuntimeDeleteFailedTitle"), this.translationService.format("RuntimePresenter.RuntimeDeleteFailedMessage", new Object[]{throwable.getMessage()}), this::forceDeleteRuntime);
            return false;
        };
    }

    protected void stopPipeline() {
        this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopTitle"), this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopMessage"), () -> {
            if (this.item.isRuntime()) {
                this.popupHelper.showInformationPopup(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionAlreadyStoppedMessage"));
            } else {
                ((RuntimeService)this.runtimeService.call(this.getStopPipelineSuccessCallback(), this.getDefaultErrorCallback())).stopPipelineExecution((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey());
            }
        });
    }

    private RemoteCallback<Void> getStopPipelineSuccessCallback() {
        return aVoid -> this.notification.fire((Object)new NotificationEvent(this.translationService.format("RuntimePresenter.PipelineExecutionStopSuccessMessage", new Object[]{((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey()).getId()}), NotificationEvent.NotificationType.SUCCESS));
    }

    protected void deletePipeline() {
        this.confirmAndExecute(this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmDeleteTitle"), this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmDeleteMessage"), () -> ((RuntimeService)this.runtimeService.call(this.getDeletePipelineSuccessCallback(), this.getDefaultErrorCallback())).deletePipelineExecution((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey()));
    }

    private RemoteCallback<Void> getDeletePipelineSuccessCallback() {
        return aVoid -> this.notification.fire((Object)new NotificationEvent(this.translationService.format("RuntimePresenter.PipelineExecutionDeleteSuccessMessage", new Object[]{((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey()).getId()}), NotificationEvent.NotificationType.SUCCESS));
    }

    protected void showPipelineError() {
        PipelineError error = this.item.getPipelineTrace().getPipelineError();
        this.popupHelper.showErrorPopup(error.getError(), error.getErrorDetail());
    }

    private void confirmAndExecute(String title, String message, Command yesCommand) {
        this.popupHelper.showYesNoPopup(title, message, yesCommand, () -> {});
    }

    private ErrorCallback<Message> getDefaultErrorCallback() {
        return this.popupHelper.getPopupErrorCallback();
    }

    private ErrorCallback<Message> getDefaultErrorCallback(boolean hideBusyIndicator) {
        return (message, throwable) -> {
            if (hideBusyIndicator) {
                this.popupHelper.hideBusyIndicator();
            }
            return this.popupHelper.getPopupErrorCallback().error(message, throwable);
        };
    }

    private boolean isFromCurrentPipeline(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        return this.item != null && !this.item.isRuntime() && ((PipelineExecutionTraceKey)this.item.getPipelineTrace().getKey()).equals((Object)pipelineExecutionTraceKey);
    }

    private boolean isFromCurrentRuntime(RuntimeKey runtimeKey) {
        return this.item != null && this.item.isRuntime() && ((RuntimeKey)this.item.getRuntime().getKey()).equals((Object)runtimeKey);
    }

    private void clearPipeline() {
        this.pipelinePresenter.clearStages();
        this.currentStages.clear();
        this.stagePresenters.values().forEach(arg_0 -> this.stagePresenterInstance.destroy(arg_0));
        this.stagePresenters.clear();
        this.currentTransitions.forEach(arg_0 -> this.transitionPresenterInstance.destroy(arg_0));
        this.currentTransitions.clear();
    }

    protected StagePresenter newStagePresenter() {
        return (StagePresenter)this.stagePresenterInstance.get();
    }

    protected TransitionPresenter newTransitionPresenter() {
        return (TransitionPresenter)this.transitionPresenterInstance.get();
    }

    protected RuntimeActionItemPresenter newActionItemPresenter() {
        return (RuntimeActionItemPresenter)this.actionItemPresenterInstance.get();
    }

    protected RuntimeActionItemSeparatorPresenter newSeparatorItem() {
        return (RuntimeActionItemSeparatorPresenter)this.actionItemSeparatorPresenterInstance.get();
    }

    public static interface View
    extends UberElement<RuntimePresenter> {
        public void setup(String var1, String var2, String var3);

        public void setEndpoint(String var1);

        public void setStatus(Collection<String> var1);

        public void setStatusTitle(String var1);

        public void addExpandedContent(IsElement var1);

        public void addActionItem(IsElement var1);

        public void clearActionItems();
    }
}

