/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class RuntimeView
implements IsElement,
RuntimePresenter.View {
    @Inject
    @DataField(value="actions-container")
    private UnorderedList actionsContainer;
    @Inject
    @DataField(value="runtime-status")
    private Span status;
    @Inject
    @DataField(value="runtime-name")
    private Div name;
    @Inject
    @DataField
    private Span date;
    @DataField
    private HTMLElement pipeline = Window.getDocument().createElement("strong");
    @Inject
    @DataField(value="runtime-endpoint")
    private Anchor endpoint;
    @Inject
    @DataField(value="expansion-area")
    private Div expansionArea;
    @Inject
    @DataField(value="expansion-content")
    private Div expansionContent;
    @Inject
    @DataField(value="expand-chevron")
    private Span chevron;
    private RuntimePresenter presenter;

    public void init(RuntimePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setup(String name, String date, String pipeline) {
        this.name.setTextContent(name);
        this.date.setTextContent(date);
        this.pipeline.setTextContent(pipeline);
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint.setHref(endpoint);
        this.endpoint.setTextContent(endpoint);
    }

    @Override
    public void setStatus(Collection<String> styles) {
        this.status.removeAttribute("class");
        for (String style : styles) {
            this.status.getClassList().add(style);
        }
    }

    @Override
    public void setStatusTitle(String title) {
        this.status.setTitle(title);
    }

    @Override
    public void addExpandedContent(org.jboss.errai.common.client.api.IsElement element) {
        this.expansionContent.appendChild((Node)element.getElement());
    }

    @Override
    public void addActionItem(org.jboss.errai.common.client.api.IsElement element) {
        this.actionsContainer.appendChild((Node)element.getElement());
    }

    @Override
    public void clearActionItems() {
        DOMUtil.removeAllChildren((Node)this.actionsContainer);
    }

    @EventHandler(value={"expand-chevron"})
    public void onOpenCloseExpand(@ForEvent(value={"click"}) Event event) {
        this.openCloseExpand();
    }

    @EventHandler(value={"close-expansion"})
    public void onCloseExpansion(@ForEvent(value={"click"}) Event event) {
        this.openCloseExpand();
    }

    private void openCloseExpand() {
        this.chevron.getClassList().toggle("fa-chevron-down");
        if (!this.chevron.getClassList().contains("fa-chevron-down")) {
            this.expansionArea.getStyle().setProperty("display", "none");
            this.chevron.getClassList().add("fa-chevron-right");
        } else {
            this.chevron.getClassList().remove("fa-chevron-right");
            this.expansionArea.getStyle().removeProperty("display");
        }
    }
}

