/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.widget.pipeline.stage;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.model.Stage;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class StagePresenter {
    private final View view;

    @Inject
    public StagePresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(Stage stage) {
        this.view.setName(stage.getName());
        this.setState(State.EXECUTING);
    }

    public void setState(State state) {
        if (state.equals((Object)State.EXECUTING)) {
            this.view.setExecutingState(State.EXECUTING.name());
        } else if (state.equals((Object)State.DONE)) {
            this.view.setDoneState(State.DONE.name());
        } else if (state.equals((Object)State.ERROR)) {
            this.view.setErrorState(State.ERROR.name());
        } else if (state.equals((Object)State.STOPPED)) {
            this.view.setStoppedState(State.STOPPED.name());
        }
    }

    public static interface View
    extends UberElement<StagePresenter> {
        public void setName(String var1);

        public void setDoneState(String var1);

        public void setExecutingState(String var1);

        public void setErrorState(String var1);

        public void setStoppedState(String var1);
    }
}

