/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.widget.pipeline.stage;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.model.Stage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class StagePresenterTest {
    private static final String STAGE_NAME = "STAGE_NAME";
    @Mock
    private StagePresenter.View view;
    private StagePresenter presenter;
    @Mock
    private Stage stage;

    @Before
    public void setUp() {
        this.presenter = new StagePresenter(this.view);
        this.presenter.init();
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        Mockito.when((Object)this.stage.getName()).thenReturn((Object)STAGE_NAME);
        this.presenter.setup(this.stage);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setName(STAGE_NAME);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setExecutingState(State.EXECUTING.name());
    }

    @Test
    public void testSetStateExecuting() {
        this.presenter.setState(State.EXECUTING);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setExecutingState(State.EXECUTING.name());
    }

    @Test
    public void testSetStateDone() {
        this.presenter.setState(State.DONE);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDoneState(State.DONE.name());
    }

    @Test
    public void testSetStateError() {
        this.presenter.setState(State.ERROR);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setErrorState(State.ERROR.name());
    }

    @Test
    public void testSetStateStopped() {
        this.presenter.setState(State.STOPPED);
        ((StagePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStoppedState(State.STOPPED.name());
    }
}

