/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.RefreshRuntimeEvent;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.wizard.NewDeployWizard;
import org.guvnor.ala.ui.client.wizard.WizardBaseTest;
import org.guvnor.ala.ui.client.wizard.pipeline.PipelineDescriptor;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsPagePresenter;
import org.guvnor.ala.ui.client.wizard.pipeline.select.SelectPipelinePagePresenter;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NewDeployWizardTest
extends WizardBaseTest {
    private static final String RUNTIME = "RUNTIME";
    private static final String TITLE = "TITLE";
    private static final int PARAM_FORMS_COUNT = 6;
    private static final int PARAM_VALUES_COUNT = 7;
    @Mock
    private SelectPipelinePagePresenter selectPipelinePage;
    @Mock
    private ManagedInstance<PipelineParamsPagePresenter> pipelineParamsPageInstance;
    @Mock
    private Instance<PipelineDescriptor> pipelineDescriptorInstance;
    @Mock
    private ErrorCallback<Message> defaultErrorCallback;
    @Mock
    private PopupHelper popupHelper;
    @Mock
    private RuntimeService runtimeService;
    private Caller<RuntimeService> runtimeServiceCaller;
    @Mock
    private EventSourceMock<RefreshRuntimeEvent> refreshRuntimeEvent;
    private NewDeployWizard wizard;
    @Mock
    private Provider provider;
    private Collection<PipelineKey> pipelines;
    private List<PipelineDescriptor> pipelineDescriptors = new ArrayList<PipelineDescriptor>();
    @Mock
    private PipelineDescriptor descriptor1;
    @Mock
    private PipelineDescriptor descriptor2;
    private List<PipelineParamsForm> paramsForms;
    private List<Map<String, String>> paramsFormsValues;
    private List<PipelineParamsPagePresenter> paramsPages = new ArrayList<PipelineParamsPagePresenter>();

    @Before
    public void setUp() {
        Mockito.when((Object)this.popupHelper.getPopupErrorCallback()).thenReturn(this.defaultErrorCallback);
        this.pipelines = new ArrayList<PipelineKey>();
        this.pipelines.add(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        this.pipelines.add(ProvisioningManagementTestCommons.PIPELINE2_KEY);
        this.pipelineDescriptors.add(this.descriptor1);
        this.pipelineDescriptors.add(this.descriptor2);
        this.paramsForms = this.mockParamForms(6);
        this.paramsFormsValues = this.mockParamFormsValues(this.paramsForms);
        Mockito.when((Object)this.pipelineDescriptorInstance.iterator()).thenReturn(this.pipelineDescriptors.iterator());
        this.paramsPages.clear();
        Mockito.when((Object)((ProviderKey)this.provider.getKey())).thenReturn((Object)((ProviderKey)Mockito.mock(ProviderKey.class)));
        Mockito.when((Object)this.translationService.getTranslation("NewDeployWizard.PipelineStartSuccessMessage")).thenReturn((Object)"SUCCESS_MESSAGE");
        this.runtimeServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.runtimeService));
        this.wizard = new NewDeployWizard(this.selectPipelinePage, (ManagedInstance)this.pipelineParamsPageInstance, (Instance)this.pipelineDescriptorInstance, this.popupHelper, this.translationService, (Caller)this.runtimeServiceCaller, (Event)this.notification, (Event)this.refreshRuntimeEvent){
            {
                this.view = NewDeployWizardTest.this.wizardView;
            }

            protected PipelineParamsPagePresenter newPipelineParamsPage(PipelineParamsForm paramsForm) {
                PipelineParamsPagePresenter pagePresenter = (PipelineParamsPagePresenter)Mockito.mock(PipelineParamsPagePresenter.class);
                Mockito.when((Object)((PipelineParamsPagePresenter)NewDeployWizardTest.this.pipelineParamsPageInstance.get())).thenReturn((Object)pagePresenter);
                NewDeployWizardTest.this.paramsPages.add(pagePresenter);
                return super.newPipelineParamsPage(paramsForm);
            }
        };
        this.wizard.init();
    }

    @Test
    public void testStart() {
        this.wizard.start(this.provider, this.pipelines);
        this.verifyStart();
    }

    @Test
    public void testGetTitle() {
        Mockito.when((Object)this.translationService.getTranslation("NewDeployWizard.Title")).thenReturn((Object)TITLE);
        Assert.assertEquals((Object)TITLE, (Object)this.wizard.getTitle());
    }

    @Test
    public void testOnStatusChangePipelinePageChangeNoPipelineSelected() {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn(null);
        this.wizard.onStatusChange(new WizardPageStatusChangeEvent((WizardPage)this.selectPipelinePage));
        Assert.assertEquals((long)1L, (long)this.wizard.getPages().size());
        Assert.assertEquals((Object)this.selectPipelinePage, this.wizard.getPages().get(0));
    }

    @Test
    public void testOnStatusChangePipelinePageSelectedWithNoParamForms() {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn((Object)ProvisioningManagementTestCommons.PIPELINE1_KEY);
        Mockito.when((Object)this.descriptor1.accept(ProvisioningManagementTestCommons.PIPELINE1_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.descriptor2.accept(ProvisioningManagementTestCommons.PIPELINE1_KEY)).thenReturn((Object)false);
        this.wizard.onStatusChange(new WizardPageStatusChangeEvent((WizardPage)this.selectPipelinePage));
        ((PipelineDescriptor)Mockito.verify((Object)this.descriptor1, (VerificationMode)Mockito.times((int)1))).accept(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        ((PipelineDescriptor)Mockito.verify((Object)this.descriptor2, (VerificationMode)Mockito.times((int)1))).accept(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        Assert.assertEquals((long)1L, (long)this.wizard.getPages().size());
        Assert.assertEquals((Object)this.selectPipelinePage, this.wizard.getPages().get(0));
        ((ManagedInstance)Mockito.verify(this.pipelineParamsPageInstance, (VerificationMode)Mockito.never())).get();
    }

    @Test
    public void testOnStatusChangePipelinePageSelectedWithParamForms() {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn((Object)ProvisioningManagementTestCommons.PIPELINE1_KEY);
        Mockito.when((Object)this.descriptor1.accept(ProvisioningManagementTestCommons.PIPELINE1_KEY)).thenReturn((Object)true);
        Mockito.when((Object)this.descriptor2.accept(ProvisioningManagementTestCommons.PIPELINE1_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.descriptor1.getParamForms()).thenReturn(this.paramsForms);
        this.wizard.onStatusChange(new WizardPageStatusChangeEvent((WizardPage)this.selectPipelinePage));
        ((PipelineDescriptor)Mockito.verify((Object)this.descriptor1, (VerificationMode)Mockito.times((int)1))).accept(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        int totalPages = 1 + this.paramsForms.size();
        Assert.assertEquals((long)totalPages, (long)this.wizard.getPages().size());
        this.paramsForms.forEach(paramsForm -> {
            ((PipelineParamsForm)Mockito.verify((Object)paramsForm, (VerificationMode)Mockito.times((int)1))).clear();
            ((PipelineParamsForm)Mockito.verify((Object)paramsForm, (VerificationMode)Mockito.times((int)1))).initialise();
        });
        ((ManagedInstance)Mockito.verify(this.pipelineParamsPageInstance, (VerificationMode)Mockito.times((int)this.paramsForms.size()))).get();
        Assert.assertEquals((long)this.paramsForms.size(), (long)this.paramsPages.size());
        for (int i = 0; i < this.paramsForms.size(); ++i) {
            PipelineParamsPagePresenter pagePresenter = this.paramsPages.get(i);
            ((PipelineParamsPagePresenter)Mockito.verify((Object)pagePresenter, (VerificationMode)Mockito.times((int)1))).setPipelineParamsForm(this.paramsForms.get(i));
        }
    }

    @Test
    public void testStartDeploymentSuccess() {
        this.wizard.start(this.provider, this.pipelines);
        this.verifyStart();
        this.preSelectForms(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        this.preCompleteWizard(ProvisioningManagementTestCommons.PIPELINE1_KEY, RUNTIME);
        this.wizard.complete();
        Map<String, String> expectedPrams = this.buildExpectedParams(this.paramsFormsValues);
        expectedPrams.put("runtime-name", RUNTIME);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).createRuntime((ProviderKey)this.provider.getKey(), RUNTIME, ProvisioningManagementTestCommons.PIPELINE1_KEY, expectedPrams);
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent("SUCCESS_MESSAGE", NotificationEvent.NotificationType.SUCCESS));
        ((EventSourceMock)Mockito.verify(this.refreshRuntimeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new RefreshRuntimeEvent((ProviderKey)this.provider.getKey()));
    }

    @Test
    public void testStartDeploymentFailure() {
        this.wizard.start(this.provider, this.pipelines);
        this.verifyStart();
        this.preSelectForms(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        this.preCompleteWizard(ProvisioningManagementTestCommons.PIPELINE1_KEY, RUNTIME);
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.runtimeService, this.runtimeServiceCaller);
        this.wizard.complete();
        Map<String, String> expectedPrams = this.buildExpectedParams(this.paramsFormsValues);
        expectedPrams.put("runtime-name", RUNTIME);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).createRuntime((ProviderKey)this.provider.getKey(), RUNTIME, ProvisioningManagementTestCommons.PIPELINE1_KEY, expectedPrams);
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error((Object)((Message)Mockito.any(Message.class)), (Throwable)Mockito.any(Throwable.class));
        ((EventSourceMock)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.never())).fire((Object)((NotificationEvent)Mockito.any(NotificationEvent.class)));
    }

    private void verifyStart() {
        Assert.assertEquals((long)1L, (long)this.wizard.getPages().size());
        Assert.assertEquals((Object)this.selectPipelinePage, this.wizard.getPages().get(0));
        ((SelectPipelinePagePresenter)Mockito.verify((Object)this.selectPipelinePage, (VerificationMode)Mockito.times((int)1))).setup(this.pipelines);
    }

    public void preSelectForms(PipelineKey pipelineKey) {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn((Object)pipelineKey);
        Mockito.when((Object)this.descriptor1.accept(pipelineKey)).thenReturn((Object)true);
        Mockito.when((Object)this.descriptor1.getParamForms()).thenReturn(this.paramsForms);
        this.wizard.onStatusChange(new WizardPageStatusChangeEvent((WizardPage)this.selectPipelinePage));
    }

    private void preCompleteWizard(PipelineKey pipelineKey, String runtimeName) {
        Mockito.when((Object)this.selectPipelinePage.getPipeline()).thenReturn((Object)pipelineKey);
        this.wizard.getPages().forEach(page -> this.preparePageCompletion((WizardPage)page));
        int index = 2;
        this.paramsFormsValues.get(index).put("runtime-name", runtimeName);
        this.wizard.isComplete(Assert::assertTrue);
    }

    private List<PipelineParamsForm> mockParamForms(int count) {
        ArrayList<PipelineParamsForm> result = new ArrayList<PipelineParamsForm>();
        for (int i = 0; i < count; ++i) {
            result.add((PipelineParamsForm)Mockito.mock(PipelineParamsForm.class));
        }
        return result;
    }

    private List<Map<String, String>> mockParamFormsValues(List<PipelineParamsForm> paramsForms) {
        ArrayList<Map<String, String>> paramValues = new ArrayList<Map<String, String>>();
        for (int i = 0; i < paramsForms.size(); ++i) {
            PipelineParamsForm form = paramsForms.get(i);
            Map<String, String> params = this.mockParamSet(7, String.valueOf(i));
            Mockito.when((Object)form.buildParams()).thenReturn(params);
            paramValues.add(params);
        }
        return paramValues;
    }

    private Map<String, String> buildExpectedParams(List<Map<String, String>> paramsList) {
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        paramsList.forEach(expectedParams::putAll);
        return expectedParams;
    }

    private Map<String, String> mockParamSet(int count, String prefix) {
        HashMap<String, String> paramSet = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            paramSet.put(prefix + ".paramName." + i, prefix + ".paramValue." + i);
        }
        return paramSet;
    }
}

