/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.actions.RuntimeActionItemPresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.actions.RuntimeActionItemSeparatorPresenter;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.pipeline.PipelinePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.transition.TransitionPresenter;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.Stage;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuntimePresenterTest {
    protected static final String RUNTIME_NAME = "RUNTIME_NAME";
    protected static final String RUNTIME_ID = "RUNTIME_ID";
    protected static final String RUNTIME_STATUS = "RUNTIME_STATUS";
    protected static final String ENDPOINT = "ENDPOINT";
    protected static final String CREATED_DATE = "CREATED_DATE";
    protected static final String DEFAULT_PIPELINE_NAME = "<system>";
    protected static final String PIPELINE_NAME = "PIPELINE_NAME";
    protected static final String EXECUTION_ID = "EXECUTION_ID";
    protected static final int STAGE_NUMBER = 10;
    @Mock
    protected RuntimePresenter.View view;
    @Mock
    protected PipelinePresenter pipelinePresenter;
    @Mock
    protected ManagedInstance<StagePresenter> stagePresenterInstance;
    @Mock
    protected ManagedInstance<TransitionPresenter> transitionPresenterInstance;
    @Mock
    protected ManagedInstance<RuntimeActionItemPresenter> actionItemPresenterInstance;
    @Mock
    protected ManagedInstance<RuntimeActionItemSeparatorPresenter> actionItemSeparatorPresenterInstance;
    @Mock
    protected RuntimeService runtimeService;
    protected Caller<RuntimeService> runtimeServiceCaller;
    @Mock
    protected EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    protected PopupHelper popupHelper;
    @Mock
    protected TranslationService translationService;
    protected RuntimePresenter presenter;
    protected List<TransitionPresenter> transitionPresenters = new ArrayList<TransitionPresenter>();
    protected List<StagePresenter> stagePresenters = new ArrayList<StagePresenter>();
    protected List<RuntimeActionItemPresenter> actionItemPresenters = new ArrayList<RuntimeActionItemPresenter>();
    protected List<RuntimeActionItemSeparatorPresenter> separatorItemPresenters = new ArrayList<RuntimeActionItemSeparatorPresenter>();
    protected RuntimeActionItemPresenter startActionPresenter;
    protected RuntimeActionItemPresenter stopActionPresenter;
    protected RuntimeActionItemPresenter deleteActionPresenter;
    protected RuntimeActionItemPresenter showErrorActionPresenter;
    protected RuntimeActionItemSeparatorPresenter separatorPresenter;
    protected RuntimeActionItemSeparatorPresenter secondarySeparatorPresenter;
    protected Runtime runtime;
    protected PipelineExecutionTrace trace;
    protected RuntimeListItem item;
    protected List<Stage> displayableStages;

    @Before
    public void setUp() {
        this.runtimeServiceCaller = new CallerMock((Object)this.runtimeService);
        this.presenter = (RuntimePresenter)Mockito.spy((Object)new RuntimePresenter(this.view, this.pipelinePresenter, (ManagedInstance)this.stagePresenterInstance, (ManagedInstance)this.transitionPresenterInstance, (ManagedInstance)this.actionItemPresenterInstance, (ManagedInstance)this.actionItemSeparatorPresenterInstance, (Caller)this.runtimeServiceCaller, (Event)this.notificationEvent, this.popupHelper, this.translationService){

            protected StagePresenter newStagePresenter() {
                StagePresenter stagePresenter = (StagePresenter)Mockito.mock(StagePresenter.class);
                Mockito.when((Object)((StagePresenter)RuntimePresenterTest.this.stagePresenterInstance.get())).thenReturn((Object)stagePresenter);
                RuntimePresenterTest.this.stagePresenters.add(stagePresenter);
                return super.newStagePresenter();
            }

            protected TransitionPresenter newTransitionPresenter() {
                TransitionPresenter transitionPresenter = (TransitionPresenter)Mockito.mock(TransitionPresenter.class);
                Mockito.when((Object)((TransitionPresenter)RuntimePresenterTest.this.transitionPresenterInstance.get())).thenReturn((Object)transitionPresenter);
                RuntimePresenterTest.this.transitionPresenters.add(transitionPresenter);
                return super.newTransitionPresenter();
            }

            protected RuntimeActionItemPresenter newActionItemPresenter() {
                RuntimeActionItemPresenter actionItemPresenter = (RuntimeActionItemPresenter)Mockito.mock(RuntimeActionItemPresenter.class);
                RuntimeActionItemPresenter.View view = (RuntimeActionItemPresenter.View)Mockito.mock(RuntimeActionItemPresenter.View.class);
                Mockito.when((Object)actionItemPresenter.getView()).thenReturn((Object)view);
                Mockito.when((Object)((RuntimeActionItemPresenter)RuntimePresenterTest.this.actionItemPresenterInstance.get())).thenReturn((Object)actionItemPresenter);
                RuntimePresenterTest.this.actionItemPresenters.add(actionItemPresenter);
                return super.newActionItemPresenter();
            }

            protected RuntimeActionItemSeparatorPresenter newSeparatorItem() {
                RuntimeActionItemSeparatorPresenter separatorItemPresenter = (RuntimeActionItemSeparatorPresenter)Mockito.mock(RuntimeActionItemSeparatorPresenter.class);
                RuntimeActionItemSeparatorPresenter.View view = (RuntimeActionItemSeparatorPresenter.View)Mockito.mock(RuntimeActionItemSeparatorPresenter.View.class);
                Mockito.when((Object)separatorItemPresenter.getView()).thenReturn((Object)view);
                Mockito.when((Object)((RuntimeActionItemSeparatorPresenter)RuntimePresenterTest.this.actionItemSeparatorPresenterInstance.get())).thenReturn((Object)separatorItemPresenter);
                RuntimePresenterTest.this.separatorItemPresenters.add(separatorItemPresenter);
                return super.newSeparatorItem();
            }
        });
        this.presenter.init();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ManagedInstance)Mockito.verify(this.actionItemPresenterInstance, (VerificationMode)Mockito.times((int)4))).get();
        ((ManagedInstance)Mockito.verify(this.actionItemSeparatorPresenterInstance, (VerificationMode)Mockito.times((int)2))).get();
        this.startActionPresenter = this.actionItemPresenters.get(0);
        this.stopActionPresenter = this.actionItemPresenters.get(1);
        this.deleteActionPresenter = this.actionItemPresenters.get(2);
        this.showErrorActionPresenter = this.actionItemPresenters.get(3);
        this.separatorPresenter = this.separatorItemPresenters.get(0);
        this.secondarySeparatorPresenter = this.separatorItemPresenters.get(1);
    }

    @Test
    public void testDestroy() {
        this.presenter.destroy();
        ((ManagedInstance)Mockito.verify(this.actionItemPresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.startActionPresenter);
        ((ManagedInstance)Mockito.verify(this.actionItemPresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.stopActionPresenter);
        ((ManagedInstance)Mockito.verify(this.actionItemPresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.deleteActionPresenter);
        ((ManagedInstance)Mockito.verify(this.actionItemSeparatorPresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.separatorPresenter);
        ((ManagedInstance)Mockito.verify(this.actionItemSeparatorPresenterInstance, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.secondarySeparatorPresenter);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    protected void preparePipelineExecutionTraceSetup() {
        Pipeline pipeline = this.mockPipeline(PIPELINE_NAME, 10);
        this.trace = this.mockPipelineExecutionTrace(EXECUTION_ID, pipeline, PipelineStatus.RUNNING, PipelineStatus.SCHEDULED);
        this.displayableStages = new ArrayList<Stage>();
        int finishedStages = 5;
        for (int i = 0; i < finishedStages; ++i) {
            this.trace.setStageStatus(((Stage)pipeline.getStages().get(i)).getName(), PipelineStatus.FINISHED);
            this.displayableStages.add((Stage)pipeline.getStages().get(i));
        }
        this.trace.setStageStatus(((Stage)pipeline.getStages().get(finishedStages)).getName(), PipelineStatus.RUNNING);
        this.displayableStages.add((Stage)pipeline.getStages().get(finishedStages));
    }

    protected Runtime mockRuntime() {
        ProviderTypeKey providerTypeKey = ProvisioningManagementTestCommons.mockProviderTypeKey((String)"1");
        ProviderKey providerKey = ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)providerTypeKey, (String)"1");
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        Runtime runtime = new Runtime(runtimeKey, RUNTIME_NAME, null, RUNTIME_STATUS, ENDPOINT, CREATED_DATE);
        return runtime;
    }

    protected Pipeline mockPipeline(String pipelineId, int stages) {
        PipelineKey pipelineKey = new PipelineKey(pipelineId);
        Pipeline pipeline = new Pipeline(pipelineKey);
        for (int i = 0; i < stages; ++i) {
            Stage stage = new Stage(pipelineKey, "Stage.name." + Integer.toString(i));
            pipeline.addStage(stage);
        }
        return pipeline;
    }

    protected PipelineExecutionTrace mockPipelineExecutionTrace(String executionId, Pipeline pipeline, PipelineStatus initialPipelineStatus, PipelineStatus initialStagesStatus) {
        PipelineExecutionTrace trace = new PipelineExecutionTrace(new PipelineExecutionTraceKey(executionId));
        trace.setPipeline(pipeline);
        trace.setPipelineStatus(initialPipelineStatus);
        pipeline.getStages().forEach(stage -> trace.setStageStatus(stage.getName(), initialStagesStatus));
        return trace;
    }
}

