/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsChangeEvent;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsPresenter;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPopup;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerConfigParamsPresenterTest {
    private static final int CONTAINER_CONFIG_COUNT = 10;
    private static final String TITLE = "TITLE";
    private static final String CONTAINER_NAME_VALUE = "CONTAINER_NAME_VALUE";
    private static final String GROUP_ID_VALUE = "GROUP_ID_VALUE";
    private static final String ARTIFACT_ID_VALUE = "ARTIFACT_ID_VALUE";
    private static final String VERSION_VALUE = "VERSION_VALUE";
    @Mock
    private ContainerConfigParamsPresenter.View view;
    @Mock
    private ContainerConfigPopup containerConfigPopup;
    @Mock
    private EventSourceMock<ContainerConfigParamsChangeEvent> configParamsChangeEvent;
    @Mock
    private TranslationService translationService;
    private ContainerConfigParamsPresenter presenter;
    @Mock
    private ListDataProvider<ContainerConfig> dataProvider;
    @Mock
    private List<ContainerConfig> dataProviderList;
    @Mock
    private HasData<ContainerConfig> dataGrid;
    private ArgumentCaptor<ParameterizedCommand> okCommandCaptor;
    private ArgumentCaptor<Command> cancelCommandCaptor;
    @Mock
    private ContentChangeHandler contentChangeHandler;

    @Before
    public void setUp() {
        this.okCommandCaptor = ArgumentCaptor.forClass(ParameterizedCommand.class);
        this.cancelCommandCaptor = ArgumentCaptor.forClass(Command.class);
        this.presenter = new ContainerConfigParamsPresenter(this.view, this.containerConfigPopup, (Event)this.configParamsChangeEvent, this.translationService){

            ListDataProvider<ContainerConfig> createDataProvider() {
                return ContainerConfigParamsPresenterTest.this.dataProvider;
            }
        };
        this.presenter.addContentChangeHandler(this.contentChangeHandler);
        Mockito.when((Object)this.dataProvider.getList()).thenReturn(this.dataProviderList);
        Mockito.when((Object)this.view.getDisplay()).thenReturn(this.dataGrid);
        this.presenter.init();
        ((ContainerConfigParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ContainerConfigParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getDisplay();
        ((ListDataProvider)Mockito.verify(this.dataProvider, (VerificationMode)Mockito.times((int)1))).addDataDisplay(this.dataGrid);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testPrepareView() {
        this.presenter.prepareView();
        ((ListDataProvider)Mockito.verify(this.dataProvider, (VerificationMode)Mockito.times((int)1))).refresh();
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((List)Mockito.verify(this.dataProviderList, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testIsComplete() {
        Mockito.when((Object)this.dataProviderList.isEmpty()).thenReturn((Object)true);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.dataProviderList.isEmpty()).thenReturn((Object)false);
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testOnGetWizardTitle() {
        Mockito.when((Object)this.view.getWizardTitle()).thenReturn((Object)TITLE);
        Assert.assertEquals((Object)TITLE, (Object)this.presenter.getWizardTitle());
    }

    @Test
    public void testOnAddContainerPopupConfirmed() {
        ArrayList currentElements = new ArrayList();
        Mockito.when((Object)this.dataProvider.getList()).thenReturn(currentElements);
        this.prepareAndCallPopup();
        ContainerConfig returnedConfig = new ContainerConfig(CONTAINER_NAME_VALUE, GROUP_ID_VALUE, ARTIFACT_ID_VALUE, VERSION_VALUE);
        ((ParameterizedCommand)this.okCommandCaptor.getValue()).execute((Object)returnedConfig);
        Assert.assertTrue((boolean)currentElements.contains(returnedConfig));
        ((EventSourceMock)Mockito.verify(this.configParamsChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ContainerConfigParamsChangeEvent(currentElements));
        ((ContentChangeHandler)Mockito.verify((Object)this.contentChangeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnAddContainerPopupCanceled() {
        ArrayList currentElements = new ArrayList();
        Mockito.when((Object)this.dataProvider.getList()).thenReturn(currentElements);
        int originalSize = currentElements.size();
        this.prepareAndCallPopup();
        ((Command)this.cancelCommandCaptor.getValue()).execute();
        Assert.assertEquals((long)originalSize, (long)currentElements.size());
        ((EventSourceMock)Mockito.verify(this.configParamsChangeEvent, (VerificationMode)Mockito.never())).fire((Object)((ContainerConfigParamsChangeEvent)Mockito.any()));
        ((ContentChangeHandler)Mockito.verify((Object)this.contentChangeHandler, (VerificationMode)Mockito.never())).onContentChange();
    }

    private void prepareAndCallPopup() {
        Mockito.when((Object)this.translationService.getTranslation("ContainerConfigParamsPresenter.AddContainerPopupTitle")).thenReturn((Object)TITLE);
        this.presenter.onAddContainer();
        ((ContainerConfigPopup)Mockito.verify((Object)this.containerConfigPopup, (VerificationMode)Mockito.times((int)1))).show((String)Mockito.eq((Object)TITLE), (ParameterizedCommand)this.okCommandCaptor.capture(), (Command)this.cancelCommandCaptor.capture(), Mockito.anyList());
    }

    @Test
    public void testOnDeleteContainer() {
        List currentElements = AlaSPITestCommons.mockList(ContainerConfig.class, (int)10);
        Mockito.when((Object)this.dataProvider.getList()).thenReturn((Object)currentElements);
        int originalSize = currentElements.size();
        int index = 4;
        ContainerConfig arbitraryElement = (ContainerConfig)currentElements.get(index);
        this.presenter.onDeleteContainer(arbitraryElement);
        Assert.assertEquals((long)(originalSize - 1), (long)currentElements.size());
        Assert.assertFalse((boolean)currentElements.contains(arbitraryElement));
        ((EventSourceMock)Mockito.verify(this.configParamsChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ContainerConfigParamsChangeEvent(currentElements));
        ((ContentChangeHandler)Mockito.verify((Object)this.contentChangeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }
}

