/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import java.util.List;
import org.guvnor.ala.ui.client.widget.popup.BaseOkCancelPopup;
import org.guvnor.ala.ui.client.widget.popup.BaseOkCancelPopupView;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPopup;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPresenter;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerConfigPopupTest {
    public static String TITLE = "TITLE";
    @Mock
    private ContainerConfigPresenter configPresenter;
    @Mock
    private ContainerConfigPresenter.View configPresenterView;
    @Mock
    private HTMLElement configPresenterViewElement;
    @Mock
    private BaseOkCancelPopupView basePopupView;
    private ContainerConfigPopup popup;
    private ParameterizedCommand okCommand = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
    private Command cancelCommand = (Command)Mockito.mock(Command.class);
    private List<String> alreadyInUseNames = (List)Mockito.mock(List.class);

    @Before
    public void setUp() {
        Mockito.when((Object)this.configPresenter.getView()).thenReturn((Object)this.configPresenterView);
        Mockito.when((Object)this.configPresenterView.getElement()).thenReturn((Object)this.configPresenterViewElement);
        this.popup = new ContainerConfigPopup((BaseOkCancelPopup.View)this.basePopupView, this.configPresenter);
        this.popup.init();
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.times((int)1))).init((BaseOkCancelPopup)this.popup);
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.times((int)1))).setContent(this.configPresenterViewElement);
    }

    @Test
    public void testShow() {
        this.popup.show(TITLE, this.okCommand, this.cancelCommand, this.alreadyInUseNames);
        ((ContainerConfigPresenter)Mockito.verify((Object)this.configPresenter, (VerificationMode)Mockito.times((int)1))).clear();
        ((ContainerConfigPresenter)Mockito.verify((Object)this.configPresenter, (VerificationMode)Mockito.times((int)1))).setup(this.alreadyInUseNames);
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.times((int)1))).show(TITLE);
    }

    @Test
    public void testOnOKWhenValidConfig() {
        this.popup.show(TITLE, this.okCommand, this.cancelCommand, this.alreadyInUseNames);
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        Mockito.when((Object)this.configPresenter.getContainerConfig()).thenReturn((Object)containerConfig);
        Mockito.when((Object)this.configPresenter.validateForSubmit()).thenReturn((Object)true);
        this.popup.onOK();
        ((ContainerConfigPresenter)Mockito.verify((Object)this.configPresenter, (VerificationMode)Mockito.times((int)1))).validateForSubmit();
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.times((int)1))).hide();
        ((ParameterizedCommand)Mockito.verify((Object)this.okCommand, (VerificationMode)Mockito.times((int)1))).execute((Object)containerConfig);
    }

    @Test
    public void testOnOKWhenInvalidConfig() {
        this.popup.show(TITLE, this.okCommand, this.cancelCommand, this.alreadyInUseNames);
        Mockito.when((Object)this.configPresenter.validateForSubmit()).thenReturn((Object)false);
        this.popup.onOK();
        ((ContainerConfigPresenter)Mockito.verify((Object)this.configPresenter, (VerificationMode)Mockito.times((int)1))).validateForSubmit();
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.never())).hide();
        ((ParameterizedCommand)Mockito.verify((Object)this.okCommand, (VerificationMode)Mockito.never())).execute(ArgumentMatchers.any());
    }

    @Test
    public void testOnCancel() {
        this.popup.show(TITLE, this.okCommand, this.cancelCommand, this.alreadyInUseNames);
        this.popup.onCancel();
        ((ContainerConfigPresenter)Mockito.verify((Object)this.configPresenter, (VerificationMode)Mockito.never())).validateForSubmit();
        ((BaseOkCancelPopupView)Mockito.verify((Object)this.basePopupView, (VerificationMode)Mockito.times((int)1))).hide();
        ((Command)Mockito.verify((Object)this.cancelCommand, (VerificationMode)Mockito.times((int)1))).execute();
    }
}

