/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.ProvisioningManagementPerspective;
import org.guvnor.ala.ui.client.events.AddNewProviderEvent;
import org.guvnor.ala.ui.client.events.AddNewProviderTypeEvent;
import org.guvnor.ala.ui.client.events.AddNewRuntimeEvent;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.wizard.EnableProviderTypeWizard;
import org.guvnor.ala.ui.client.wizard.NewDeployWizard;
import org.guvnor.ala.ui.client.wizard.NewProviderWizard;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProvisioningManagementPerspectiveTest {
    private static final int PROVIDER_TYPE_COUNT = 10;
    @Mock
    private ProviderTypeService providerTypeService;
    @Mock
    private RuntimeService runtimeService;
    @Mock
    private EnableProviderTypeWizard enableProviderTypeWizard;
    @Mock
    private NewProviderWizard newProviderWizard;
    @Mock
    private NewDeployWizard newDeployWizard;
    @Mock
    private ClientProviderHandlerRegistry handlerRegistry;
    private ProvisioningManagementPerspective perspective;
    private ArgumentCaptor<List> providerTypesCaptor;

    @Before
    public void setUp() {
        this.perspective = new ProvisioningManagementPerspective((Caller)new CallerMock((Object)this.providerTypeService), (Caller)new CallerMock((Object)this.runtimeService), this.enableProviderTypeWizard, this.newProviderWizard, this.newDeployWizard, this.handlerRegistry);
        this.providerTypesCaptor = ArgumentCaptor.forClass(List.class);
    }

    @Test
    public void testAddNewProviderType() {
        List providerTypes = ProvisioningManagementTestCommons.mockProviderTypeList((int)10);
        HashMap providerTypeStatusMap = new HashMap();
        providerTypes.forEach(providerType -> providerTypeStatusMap.put(providerType, (ProviderTypeStatus)Mockito.mock(ProviderTypeStatus.class)));
        Mockito.when((Object)this.providerTypeService.getProviderTypesStatus()).thenReturn(providerTypeStatusMap);
        ArrayList<ProviderType> properlyInstalledProviderTypes = new ArrayList<ProviderType>();
        properlyInstalledProviderTypes.add((ProviderType)providerTypes.get(0));
        properlyInstalledProviderTypes.add((ProviderType)providerTypes.get(3));
        properlyInstalledProviderTypes.add((ProviderType)providerTypes.get(5));
        properlyInstalledProviderTypes.forEach(providerType -> Mockito.when((Object)this.handlerRegistry.isProviderInstalled((ProviderTypeKey)providerType.getKey())).thenReturn((Object)true));
        this.perspective.onAddNewProviderType((AddNewProviderTypeEvent)Mockito.mock(AddNewProviderTypeEvent.class));
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).getProviderTypesStatus();
        ((EnableProviderTypeWizard)Mockito.verify((Object)this.enableProviderTypeWizard, (VerificationMode)Mockito.times((int)1))).start((List)this.providerTypesCaptor.capture());
        Assert.assertEquals((long)properlyInstalledProviderTypes.size(), (long)((List)this.providerTypesCaptor.getValue()).size());
        List capturedValues = (List)this.providerTypesCaptor.getValue();
        capturedValues.forEach(value -> Assert.assertTrue((boolean)properlyInstalledProviderTypes.contains(value.getK1())));
    }

    @Test
    public void testAddNewProvider() {
        ProviderType providerType = ProvisioningManagementTestCommons.mockProviderType((String)"");
        this.perspective.onAddNewProvider(new AddNewProviderEvent(providerType));
        ((NewProviderWizard)Mockito.verify((Object)this.newProviderWizard, (VerificationMode)Mockito.times((int)1))).start(providerType);
    }

    @Test
    public void testAddNewRuntime() {
        Provider provider = new Provider(ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)ProvisioningManagementTestCommons.mockProviderTypeKey((String)""), (String)""), (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class));
        List pipelines = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.runtimeService.getPipelines(((ProviderKey)provider.getKey()).getProviderTypeKey())).thenReturn((Object)pipelines);
        this.perspective.onAddNewRuntime(new AddNewRuntimeEvent(provider));
        ((NewDeployWizard)Mockito.verify((Object)this.newDeployWizard, (VerificationMode)Mockito.times((int)1))).start(provider, (Collection)pipelines);
    }
}

