/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.navigation.providertype;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.events.AddNewProviderEvent;
import org.guvnor.ala.ui.client.events.ProviderSelectedEvent;
import org.guvnor.ala.ui.client.events.ProviderTypeListRefreshEvent;
import org.guvnor.ala.ui.client.navigation.providertype.ProviderTypePresenter;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProviderTypePresenterTest {
    private static final int PROVIDERS_SIZE = 5;
    @Mock
    private ProviderTypePresenter.View view;
    @Mock
    private ProviderTypeService providerTypeService;
    private Caller<ProviderTypeService> providerTypeServiceCaller;
    @Mock
    private EventSourceMock<AddNewProviderEvent> addNewProviderEvent;
    @Mock
    private EventSourceMock<ProviderTypeListRefreshEvent> providerTypeListRefreshEvent;
    @Mock
    private EventSourceMock<ProviderSelectedEvent> providerSelectedEvent;
    private ProviderTypePresenter presenter;
    private ProviderType providerType;
    private List<ProviderKey> providers;
    private ProviderKey provider;

    @Before
    public void setUp() {
        this.providerType = ProvisioningManagementTestCommons.mockProviderType((String)"0");
        this.providers = this.createProviders((ProviderTypeKey)this.providerType.getKey(), 5);
        this.provider = this.providers.get(0);
        this.providerTypeServiceCaller = new CallerMock((Object)this.providerTypeService);
        this.presenter = new ProviderTypePresenter(this.view, this.providerTypeServiceCaller, this.addNewProviderEvent, this.providerTypeListRefreshEvent, this.providerSelectedEvent);
        this.presenter.init();
        ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetup() {
        this.presenter.setup(this.providerType, this.providers, this.provider);
        ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderTypeName(UIUtil.getDisplayableProviderTypeName((ProviderType)this.providerType));
        this.providers.forEach(providerKey -> ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addProvider((String)ArgumentMatchers.eq((Object)this.provider.getId()), (String)ArgumentMatchers.eq((Object)this.provider.getId()), (Command)ArgumentMatchers.any(Command.class)));
        ((EventSourceMock)Mockito.verify(this.providerSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderSelectedEvent(this.provider));
    }

    @Test
    public void onProviderSelectTest() {
        this.presenter.setup(this.providerType, this.providers, this.provider);
        this.providers.forEach(providerKey -> {
            this.presenter.onProviderSelect(new ProviderSelectedEvent(providerKey));
            ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).select(providerKey.getId());
        });
    }

    @Test
    public void onAddNewProviderTest() {
        this.presenter.setup(this.providerType, this.providers, this.provider);
        this.presenter.onAddNewProvider();
        ((EventSourceMock)Mockito.verify(this.addNewProviderEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new AddNewProviderEvent(this.providerType));
    }

    @Test
    public void onRemoveProviderTypeTest() {
        this.presenter.setup(this.providerType, this.providers, this.provider);
        this.presenter.onRemoveProviderType();
        ((ProviderTypePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).confirmRemove((Command)ArgumentMatchers.any(Command.class));
        this.presenter.removeProviderType();
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).disableProviderType(this.providerType);
        ((EventSourceMock)Mockito.verify(this.providerTypeListRefreshEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new ProviderTypeListRefreshEvent());
    }

    private List<ProviderKey> createProviders(ProviderTypeKey providerTypeKey, int size) {
        ArrayList<ProviderKey> result = new ArrayList<ProviderKey>();
        for (int i = 0; i < size; ++i) {
            result.add(ProvisioningManagementTestCommons.mockProviderKey((ProviderTypeKey)providerTypeKey, (String)Integer.toString(i)));
        }
        return result;
    }
}

