/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterTest;
import org.guvnor.ala.ui.client.provider.status.runtime.actions.RuntimeActionItemPresenter;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.RuntimeStatus;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

public class RuntimePresenterActionsSetupTest
extends RuntimePresenterTest {
    private static final String STOP_PIPELINE_ACTION = "STOP_PIPELINE_ACTION";
    private static final String DELETE_PIPELINE_ACTION = "DELETE_PIPELINE_ACTION";
    private static final String STOP_RUNTIME_ACTION = "STOP_RUNTIME_ACTION";
    private static final String START_RUNTIME_ACTION = "START_RUNTIME_ACTION";
    private static final String DELETE_RUNTIME_ACTION = "DELETE_RUNTIME_ACTION";
    private static final String SHOW_PIPELINE_ERROR_ACTION = "SHOW_PIPELINE_ERROR_ACTION";

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionStopAction")).thenReturn((Object)STOP_PIPELINE_ACTION);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionDeleteAction")).thenReturn((Object)DELETE_PIPELINE_ACTION);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionShowErrorAction")).thenReturn((Object)SHOW_PIPELINE_ERROR_ACTION);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStartAction")).thenReturn((Object)START_RUNTIME_ACTION);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStopAction")).thenReturn((Object)STOP_RUNTIME_ACTION);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeleteAction")).thenReturn((Object)DELETE_RUNTIME_ACTION);
    }

    @Test
    public void testPipelineActionsSetupForScheduledPipeline() {
        this.preparePipelineActionsSetupTest(PipelineStatus.SCHEDULED);
        this.verifyPipelineActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    @Test
    public void testPipelineActionsSetupForRunningPipeline() {
        this.preparePipelineActionsSetupTest(PipelineStatus.RUNNING);
        this.verifyPipelineActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    @Test
    public void testPipelineActionsSetupForErrorPipeline() {
        this.preparePipelineActionsSetupTest(PipelineStatus.ERROR);
        this.verifyPipelineActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
    }

    @Test
    public void testPipelineActionsSetupForStoppedPipeline() {
        this.preparePipelineActionsSetupTest(PipelineStatus.STOPPED);
        this.verifyPipelineActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    private void preparePipelineActionsSetupTest(PipelineStatus status) {
        this.preparePipelineExecutionTraceSetup();
        this.trace.setPipelineStatus(status);
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
    }

    private void verifyPipelineActionsCommonSetup() {
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearActionItems();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)STOP_PIPELINE_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)DELETE_PIPELINE_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)SHOW_PIPELINE_ERROR_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.stopActionPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.separatorPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.deleteActionPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addActionItem((IsElement)this.startActionPresenter.getView());
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
    }

    @Test
    public void testRuntimeActionsSetupForRunningRuntime() {
        this.prepareRuntimeActionsSetupTest(RuntimeStatus.RUNNING.name());
        this.verifyRuntimeActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    @Test
    public void testRuntimeActionsForStoppedRuntime() {
        this.prepareRuntimeActionsSetupTest(RuntimeStatus.STOPPED.name());
        this.verifyRuntimeActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    @Test
    public void testRuntimeActionsForUnknownStateRuntime() {
        this.prepareRuntimeActionsSetupTest(RuntimeStatus.UNKNOWN.name());
        this.verifyRuntimeActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    @Test
    public void testRuntimeActionsForUndefinedStateRuntime() {
        this.prepareRuntimeActionsSetupTest("undefined value");
        this.verifyRuntimeActionsCommonSetup();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.never())).setEnabled(false);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.showErrorActionPresenter, (VerificationMode)Mockito.never())).setEnabled(true);
    }

    private void prepareRuntimeActionsSetupTest(String status) {
        this.runtime = this.mockRuntime();
        this.runtime.setStatus(status);
        this.item = new RuntimeListItem("RUNTIME_NAME", this.runtime);
        this.presenter.setup(this.item);
    }

    private void verifyRuntimeActionsCommonSetup() {
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearActionItems();
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)START_RUNTIME_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)STOP_RUNTIME_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setup((String)Mockito.eq((Object)DELETE_RUNTIME_ACTION), (Command)Mockito.any(Command.class));
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.stopActionPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.deleteActionPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.separatorPresenter.getView());
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addActionItem((IsElement)this.deleteActionPresenter.getView());
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.stopActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.startActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((RuntimeActionItemPresenter)Mockito.verify((Object)this.deleteActionPresenter, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
    }
}

