/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import java.util.List;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterHelper;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterTest;
import org.guvnor.ala.ui.client.widget.pipeline.PipelinePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.StagePresenter;
import org.guvnor.ala.ui.client.widget.pipeline.stage.State;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.Stage;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuntimePresenterSetupsTest
extends RuntimePresenterTest {
    @Test
    public void testSetupRuntimeWithNoTrace() {
        this.runtime = this.mockRuntime();
        this.item = new RuntimeListItem("RUNTIME_NAME", this.runtime);
        this.presenter.setup(this.item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)1))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup("RUNTIME_NAME", "CREATED_DATE", "<system>");
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEndpoint("ENDPOINT");
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.never())).addStage((IsElement)Mockito.any());
    }

    @Test
    public void testSetupRuntimeWithTrace() {
        this.runtime = this.mockRuntime();
        this.preparePipelineExecutionTraceSetup();
        this.item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.runtime.setPipelineTrace(this.trace);
        this.item = new RuntimeListItem("RUNTIME_NAME", this.runtime);
        this.presenter.setup(this.item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)2))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup("RUNTIME_NAME", "CREATED_DATE", "PIPELINE_NAME");
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEndpoint("ENDPOINT");
        this.verifyPipelineWasSet(this.trace, this.displayableStages);
    }

    @Test
    public void testSetupPipelineExecutionTrace() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)2))).clearStages();
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup("RUNTIME_NAME", "", "PIPELINE_NAME");
        this.verifyPipelineWasSet(this.trace, this.displayableStages);
    }

    @Test
    public void testOnStageStatusChangeLastVisibleStageChanged() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        int initialStagePresentersSize = this.stagePresenters.size();
        Stage stage = (Stage)this.displayableStages.get(this.displayableStages.size() - 1);
        this.presenter.onStageStatusChange(new StageStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), stage.getName(), PipelineStatus.FINISHED));
        StagePresenter stagePresenter = (StagePresenter)this.stagePresenters.get(this.stagePresenters.size() - 1);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.EXECUTING);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.DONE);
        ((ManagedInstance)Mockito.verify((Object)this.stagePresenterInstance, (VerificationMode)Mockito.times((int)initialStagePresentersSize))).get();
    }

    @Test
    public void testOnStageStatusChangeNewStageChanged() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        int initialStagePresentersSize = this.stagePresenters.size();
        Stage stage = (Stage)item.getPipelineTrace().getPipeline().getStages().get(this.displayableStages.size());
        this.presenter.onStageStatusChange(new StageStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), stage.getName(), PipelineStatus.RUNNING));
        ((ManagedInstance)Mockito.verify((Object)this.stagePresenterInstance, (VerificationMode)Mockito.times((int)(initialStagePresentersSize + 1)))).get();
        StagePresenter stagePresenter = (StagePresenter)this.stagePresenters.get(this.stagePresenters.size() - 1);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setup(stage);
        ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setState(State.EXECUTING);
    }

    @Test
    public void testOnPipelineStatusChange() {
        this.preparePipelineExecutionTraceSetup();
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        this.presenter.onPipelineStatusChange(new PipelineStatusChangeEvent((PipelineExecutionTraceKey)this.trace.getKey(), PipelineStatus.FINISHED));
        ((RuntimePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStatus(RuntimePresenterHelper.buildIconStyle((PipelineStatus)PipelineStatus.FINISHED));
    }

    private void verifyPipelineWasSet(PipelineExecutionTrace trace, List<Stage> displayableStages) {
        int stagesSize = displayableStages.size();
        int transitionsSize = stagesSize > 0 ? stagesSize - 1 : 0;
        for (int i = 0; i < displayableStages.size(); ++i) {
            StagePresenter stagePresenter = (StagePresenter)this.stagePresenters.get(i);
            ((StagePresenter)Mockito.verify((Object)stagePresenter, (VerificationMode)Mockito.times((int)1))).setup(displayableStages.get(i));
        }
        ((ManagedInstance)Mockito.verify((Object)this.stagePresenterInstance, (VerificationMode)Mockito.times((int)stagesSize))).get();
        ((ManagedInstance)Mockito.verify((Object)this.transitionPresenterInstance, (VerificationMode)Mockito.times((int)transitionsSize))).get();
        ((PipelinePresenter)Mockito.verify((Object)this.pipelinePresenter, (VerificationMode)Mockito.times((int)(stagesSize + transitionsSize)))).addStage((IsElement)Mockito.any());
    }
}

