/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.pipeline.select.item;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.wizard.pipeline.select.item.PipelineItemPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class PipelineItemPresenterTest {
    @Mock
    private PipelineItemPresenter.View view;
    private PipelineItemPresenter presenter;
    private Collection<PipelineItemPresenter> others;
    private Collection<PipelineItemPresenter> all;
    private static final int TOTAL_ITEMS = 5;

    @Before
    public void setUp() {
        this.presenter = new PipelineItemPresenter(this.view);
        this.presenter.init();
        ((PipelineItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        this.others = new ArrayList<PipelineItemPresenter>();
        for (int i = 0; i < 4; ++i) {
            PipelineItemPresenter itemPresenter = new PipelineItemPresenter((PipelineItemPresenter.View)Mockito.mock(PipelineItemPresenter.View.class));
            this.others.add(itemPresenter);
        }
        this.all = new ArrayList<PipelineItemPresenter>();
        this.all.addAll(this.others);
        this.all.add(this.presenter);
    }

    @Test
    public void testSetup() {
        this.presenter.setup(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        ((PipelineItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPipelineName("PIPELINE1");
    }

    @Test
    public void testGetPipeline() {
        this.presenter.setup(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        Assert.assertEquals((Object)ProvisioningManagementTestCommons.PIPELINE1_KEY, (Object)this.presenter.getPipeline());
    }

    @Test
    public void testIsSelected() {
        Mockito.when((Object)this.view.isSelected()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.presenter.isSelected());
        Mockito.when((Object)this.view.isSelected()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.isSelected());
    }

    @Test
    public void testPipelineSelected() {
        this.testSelection(true);
    }

    @Test
    public void testPipelineUnSelected() {
        this.testSelection(false);
    }

    private void testSelection(boolean selected) {
        this.presenter.setup(ProvisioningManagementTestCommons.PIPELINE1_KEY);
        this.presenter.addOthers(this.all);
        Mockito.when((Object)this.view.isSelected()).thenReturn((Object)selected);
        this.presenter.onItemClick();
        this.others.forEach(other -> {
            if (selected) {
                ((PipelineItemPresenter.View)Mockito.verify((Object)((PipelineItemPresenter.View)other.getView()), (VerificationMode)Mockito.times((int)1))).setSelected(false);
            } else {
                ((PipelineItemPresenter.View)Mockito.verify((Object)((PipelineItemPresenter.View)other.getView()), (VerificationMode)Mockito.never())).setSelected(Mockito.anyBoolean());
            }
        });
        ((PipelineItemPresenter.View)Mockito.verify((Object)((PipelineItemPresenter.View)this.presenter.getView()), (VerificationMode)Mockito.never())).setSelected(selected);
    }
}

