/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.backend.service;

import org.guvnor.ala.ui.wildfly.backend.service.WildflyClientServiceImpl;
import org.guvnor.ala.ui.wildfly.service.TestConnectionResult;
import org.guvnor.ala.ui.wildfly.service.WildflyClientService;
import org.guvnor.ala.wildfly.access.WildflyClient;
import org.guvnor.ala.wildfly.access.exceptions.WildflyClientException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WildflyClientServiceImplTest {
    private static final String CONNECTION_SUCCESSFUL = "CONNECTION_SUCCESSFUL";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    private static final String DUMMY_VALUE = "DUMMY_VALUE";
    private static final int DUMMY_INT_VALUE = 9990;
    @Mock
    private WildflyClient wfClient;
    private WildflyClientService wildflyClientService;

    @Before
    public void setUp() {
        this.wildflyClientService = new WildflyClientServiceImpl(){

            protected WildflyClient createWFClient(String host, int port, int managementPort, String user, String password) {
                return WildflyClientServiceImplTest.this.wfClient;
            }
        };
    }

    @Test
    public void testTestConnectionSuccessful() {
        Mockito.when((Object)this.wfClient.testConnection()).thenReturn((Object)CONNECTION_SUCCESSFUL);
        TestConnectionResult result = this.wildflyClientService.testConnection(DUMMY_VALUE, 9990, 9990, DUMMY_VALUE, DUMMY_VALUE);
        Assert.assertFalse((boolean)result.getManagementConnectionError());
        Assert.assertEquals((Object)CONNECTION_SUCCESSFUL, (Object)result.getManagementConnectionMessage());
    }

    @Test
    public void testTestConnectionFailed() {
        Mockito.when((Object)this.wfClient.testConnection()).thenThrow(new Throwable[]{new WildflyClientException(ERROR_MESSAGE)});
        TestConnectionResult result = this.wildflyClientService.testConnection(DUMMY_VALUE, 9990, 9990, DUMMY_VALUE, DUMMY_VALUE);
        Assert.assertTrue((boolean)result.getManagementConnectionError());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)result.getManagementConnectionMessage());
    }
}

