/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.backend.handler;

import java.util.HashMap;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.wildfly.backend.handler.WildflyProviderConfigConverter;
import org.guvnor.ala.wildfly.config.WildflyProviderConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WildflyProviderConfigConverterTest {
    private static final String PROVIDER_NAME_VALUE = "PROVIDER_NAME_VALUE";
    private static final String HOST_VALUE = "HOST_VALUE";
    private static final String PORT_VALUE = "PORT_VALUE";
    private static final String MANAGEMENT_PORT_VALUE = "MANAGEMENT_PORT_VALUE";
    private static final String WILDFLY_USER_VALUE = "WILDFLY_USER_VALUE";
    private static final String WILDFLY_PASSWORD_VALUE = "WILDFLY_PASSWORD_VALUE";
    private WildflyProviderConfigConverter converter;

    @Before
    public void setUp() {
        this.converter = new WildflyProviderConfigConverter();
    }

    @Test
    public void testToDomain() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("host", HOST_VALUE);
        values.put("port", PORT_VALUE);
        values.put("management-port", MANAGEMENT_PORT_VALUE);
        values.put("wildfly-user", WILDFLY_USER_VALUE);
        values.put("wildfly-password", WILDFLY_PASSWORD_VALUE);
        ProviderConfiguration configuration = new ProviderConfiguration(PROVIDER_NAME_VALUE, values);
        WildflyProviderConfig result = this.converter.toDomain(configuration);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)result.getName());
        Assert.assertEquals((Object)HOST_VALUE, (Object)result.getHost());
        Assert.assertEquals((Object)PORT_VALUE, (Object)result.getPort());
        Assert.assertEquals((Object)MANAGEMENT_PORT_VALUE, (Object)result.getManagementPort());
        Assert.assertEquals((Object)WILDFLY_USER_VALUE, (Object)result.getUser());
        Assert.assertEquals((Object)WILDFLY_PASSWORD_VALUE, (Object)result.getPassword());
    }

    @Test
    public void testToDomainNull() {
        Assert.assertNull((Object)this.converter.toDomain(null));
    }

    @Test
    public void testToModel() {
        WildflyProviderConfig config = (WildflyProviderConfig)Mockito.mock(WildflyProviderConfig.class);
        Mockito.when((Object)config.getName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)config.getHost()).thenReturn((Object)HOST_VALUE);
        Mockito.when((Object)config.getPort()).thenReturn((Object)PORT_VALUE);
        Mockito.when((Object)config.getManagementPort()).thenReturn((Object)MANAGEMENT_PORT_VALUE);
        Mockito.when((Object)config.getUser()).thenReturn((Object)WILDFLY_USER_VALUE);
        Mockito.when((Object)config.getPassword()).thenReturn((Object)WILDFLY_PASSWORD_VALUE);
        ProviderConfiguration result = this.converter.toModel(config);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)result.getId());
        Assert.assertEquals((Object)HOST_VALUE, result.getValues().get("host"));
        Assert.assertEquals((Object)PORT_VALUE, result.getValues().get("port"));
        Assert.assertEquals((Object)MANAGEMENT_PORT_VALUE, result.getValues().get("management-port"));
        Assert.assertEquals((Object)WILDFLY_USER_VALUE, result.getValues().get("wildfly-user"));
        Assert.assertEquals((Object)WILDFLY_PASSWORD_VALUE, result.getValues().get("wildfly-password"));
    }

    @Test
    public void testToModelNull() {
        Assert.assertNull((Object)this.converter.toModel(null));
    }
}

