/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.client.provider;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.StyleHelper;
import org.guvnor.ala.ui.wildfly.client.provider.WF10ProviderConfigPresenter;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;

@Dependent
@Templated
public class WF10ProviderConfigView
implements IsElement,
WF10ProviderConfigPresenter.View {
    @Inject
    @DataField(value="provider-name-form")
    private Div providerNameForm;
    @DataField(value="provider-type-name")
    private HTMLElement providerTypeName = Window.getDocument().createElement("strong");
    @Inject
    @DataField(value="provider-name")
    private TextInput name;
    @Inject
    @DataField(value="host-form")
    private Div hostForm;
    @Inject
    @DataField(value="host")
    private TextInput host;
    @Inject
    @DataField(value="port-form")
    private Div portForm;
    @Inject
    @DataField(value="port")
    private TextInput port;
    @Inject
    @DataField(value="management-port")
    private TextInput managementPort;
    @Inject
    @DataField(value="management-port-form")
    private Div managementPortForm;
    @Inject
    @DataField(value="username-form")
    private Div usernameForm;
    @Inject
    @DataField(value="username")
    private TextInput username;
    @Inject
    @DataField(value="password-form")
    private Div passwordForm;
    @Inject
    @DataField(value="password")
    private TextInput password;
    @Inject
    @DataField(value="test-connection-button")
    private Button testConnectionButton;
    @Inject
    private TranslationService translationService;
    @Inject
    private PopupHelper popupHelper;
    private WF10ProviderConfigPresenter presenter;

    @PostConstruct
    private void init() {
        this.providerTypeName.setTextContent(this.getWizardTitle());
    }

    public void init(WF10ProviderConfigPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getProviderName() {
        return this.name.getValue();
    }

    @Override
    public String getHost() {
        return this.host.getValue();
    }

    @Override
    public String getPort() {
        return this.port.getValue();
    }

    @Override
    public String getManagementPort() {
        return this.managementPort.getValue();
    }

    @Override
    public String getUsername() {
        return this.username.getValue();
    }

    @Override
    public String getPassword() {
        return this.password.getValue();
    }

    @Override
    public void setProviderName(String name) {
        this.name.setValue(name);
    }

    @Override
    public void setHost(String host) {
        this.host.setValue(host);
    }

    @Override
    public void setPort(String port) {
        this.port.setValue(port);
    }

    @Override
    public void setManagementPort(String managementPort) {
        this.managementPort.setValue(managementPort);
    }

    @Override
    public void setUsername(String username) {
        this.username.setValue(username);
    }

    @Override
    public void setPassword(String password) {
        this.password.setValue(password);
    }

    @Override
    public void disable() {
        this.resetFormState();
        this.enable(false);
    }

    @Override
    public void enable() {
        this.resetFormState();
        this.enable(true);
    }

    @Override
    public void setProviderNameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.providerNameForm, (FormStatus)status);
    }

    @Override
    public void setHostStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.hostForm, (FormStatus)status);
    }

    @Override
    public void setPortStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.portForm, (FormStatus)status);
    }

    @Override
    public void setManagementPortStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.managementPortForm, (FormStatus)status);
    }

    @Override
    public void setUsernameStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.usernameForm, (FormStatus)status);
    }

    @Override
    public void setPasswordStatus(FormStatus status) {
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        StyleHelper.setFormStatus((HTMLElement)this.passwordForm, (FormStatus)status);
    }

    @Override
    public void clear() {
        this.resetFormState();
        this.name.setValue("");
        this.host.setValue("");
        this.port.setValue("");
        this.managementPort.setValue("");
        this.username.setValue("");
        this.password.setValue("");
    }

    @Override
    public String getWizardTitle() {
        return "WildFly 10";
    }

    @Override
    public String getParamsNotCompletedErrorMessage() {
        return this.translationService.format("WF10ProviderConfigView.AllParamsNeedsCompletionForValidationMessage", new Object[0]);
    }

    @Override
    public String getTestConnectionFailMessage(String content) {
        return this.translationService.format("WF10ProviderConfigView.TestConnectionFailMessage", new Object[]{content});
    }

    @Override
    public String getTestConnectionSuccessfulMessage(String content) {
        return this.translationService.format("WF10ProviderConfigView.TestConnectionSuccessfulMessage", new Object[]{content});
    }

    @Override
    public String getTestConnectionUnExpectedErrorMessage(String content) {
        return this.translationService.format("WF10ProviderConfigView.TestConnectionUnExpectedErrorMessage", new Object[]{content});
    }

    @Override
    public void showErrorPopup(String message) {
        this.popupHelper.showErrorPopup(message);
    }

    @Override
    public void showInformationPopup(String message) {
        this.popupHelper.showInformationPopup(message);
    }

    private void enable(boolean enabled) {
        this.name.setDisabled(!enabled);
        this.host.setDisabled(!enabled);
        this.port.setDisabled(!enabled);
        this.managementPort.setDisabled(!enabled);
        this.username.setDisabled(!enabled);
        this.password.setDisabled(!enabled);
        this.testConnectionButton.setDisabled(!enabled);
    }

    private void resetFormState() {
        StyleHelper.setFormStatus((HTMLElement)this.providerNameForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.hostForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.portForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.managementPortForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.usernameForm, (FormStatus)FormStatus.VALID);
        StyleHelper.setFormStatus((HTMLElement)this.passwordForm, (FormStatus)FormStatus.VALID);
    }

    @EventHandler(value={"provider-name"})
    private void onProviderNameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onProviderNameChange();
    }

    @EventHandler(value={"host"})
    private void onHostChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onHostChange();
    }

    @EventHandler(value={"port"})
    private void onPortChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onPortChange();
    }

    @EventHandler(value={"management-port"})
    private void onManagementPortChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onManagementPortChange();
    }

    @EventHandler(value={"username"})
    private void onUsernameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onUserNameChange();
    }

    @EventHandler(value={"password"})
    private void onPasswordChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onPasswordChange();
    }

    @EventHandler(value={"test-connection-button"})
    private void onTestConnection(@ForEvent(value={"click"}) Event event) {
        this.presenter.onTestConnection();
    }
}

