/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.migration.cli.ToolConfig;

public class ToolConfigTest {
    private ToolConfig.DefaultFactory defaultFactory;

    @Before
    public void init() {
        this.defaultFactory = new ToolConfig.DefaultFactory();
    }

    @Test(expected=ParseException.class)
    public void testNoTargetParameter() throws ParseException {
        String[] args = new String[]{};
        this.defaultFactory.parse(args);
    }

    @Test(expected=MissingArgumentException.class)
    public void testNoTargetArgument() throws ParseException {
        String[] args = new String[]{"-t"};
        this.defaultFactory.parse(args);
    }

    @Test
    public void testBatchArgument() throws ParseException {
        String[] args = new String[]{"-t", "/fake/dir", "-b", ""};
        Assert.assertTrue((boolean)this.defaultFactory.parse(args).isBatch());
    }

    @Test
    public void testPrintHelp() throws IOException {
        String APP_NAME = "myAppName";
        File tf = File.createTempFile("printTestFile", ".txt");
        try (PrintStream ps = new PrintStream(tf);
             BufferedReader br = new BufferedReader(new FileReader(tf));){
            this.defaultFactory.printHelp(ps, "myAppName");
            Assert.assertTrue((boolean)br.readLine().contains("myAppName"));
        }
    }

    @Test
    public void testGetTarget() throws ParseException {
        String[] args = new String[]{"-t", "/fake/dir"};
        CommandLine cl = new CLIManager().parse(args);
        Path path = new ToolConfig(cl).getTarget();
        Assert.assertEquals((long)2L, (long)path.getNameCount());
        Assert.assertEquals((Object)"fake", (Object)path.getName(0).toString());
    }
}

