/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines;

import java.util.function.Function;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.legacy.services.impl.FormSerializationManagerImpl;
import org.kie.workbench.common.forms.migration.tool.Resource;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationContext;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationStep;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractMigrationStep
implements MigrationStep {
    @Override
    public void execute(MigrationContext migrationContext) {
        migrationContext.getSystem().console().format("Starting %s\n", new Object[]{this.getName()});
        this.doExecute(migrationContext);
        this.persist(migrationContext);
        migrationContext.getSystem().console().format("Finished %s\n", new Object[]{this.getName()});
    }

    private void persist(MigrationContext migrationContext) {
        FormSerializationManagerImpl oldFormSerializer = new FormSerializationManagerImpl();
        FormDefinitionSerializer formDefinitionSerializer = migrationContext.getFormCDIWrapper().getFormDefinitionSerializer();
        Function<Resource, String> originaldFormSerializationFunction = formResource -> {
            Form originalForm = (Form)formResource.get();
            originalForm.setMigrationStep(this.getStep());
            return oldFormSerializer.generateFormXML(originalForm, migrationContext.getSystem());
        };
        Function<Resource, String> newFormSerializationFuncion = formResource -> formDefinitionSerializer.serialize((FormDefinition)formResource.get());
        migrationContext.getSummaries().forEach(summary -> {
            if (summary.getResult().isSuccess()) {
                this.serializeResource(summary.getOriginalForm().getPath(), (String)originaldFormSerializationFunction.apply(summary.getOriginalForm()), migrationContext);
                this.serializeResource(summary.getNewForm().getPath(), (String)newFormSerializationFuncion.apply(summary.getNewForm()), migrationContext);
            }
        });
        migrationContext.getExtraSummaries().forEach(summary -> this.serializeResource(summary.getNewForm().getPath(), (String)newFormSerializationFuncion.apply(summary.getNewForm()), migrationContext));
    }

    private void serializeResource(Path path, String content, MigrationContext context) {
        context.getMigrationServicesCDIWrapper().write(path, content, "Migration Step #" + this.getStep() + ": " + this.getName());
    }

    protected abstract void doExecute(MigrationContext var1);
}

