/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@Portable
public class FormDefinition {
    private String id;
    private String name;
    private FormModel model;
    private List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private LayoutTemplate layoutTemplate;

    public FormDefinition() {
    }

    public FormDefinition(@MapsTo(value="model") FormModel model) {
        this.model = model;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public LayoutTemplate getLayoutTemplate() {
        return this.layoutTemplate;
    }

    public void setLayoutTemplate(LayoutTemplate layoutTemplate) {
        this.layoutTemplate = layoutTemplate;
    }

    public FormModel getModel() {
        return this.model;
    }

    public void setModel(FormModel model) {
        this.model = model;
    }

    public FieldDefinition getFieldByBinding(String binding) {
        return this.getFieldBy(field -> field.getBinding() != null && field.getBinding().equals(binding));
    }

    public FieldDefinition getFieldByName(String name) {
        return this.getFieldBy(field -> field.getName().equals(name));
    }

    public FieldDefinition getFieldById(String fieldId) {
        return this.getFieldBy(field -> field.getId().equals(fieldId));
    }

    public FieldDefinition getFieldByBoundProperty(ModelProperty property) {
        return this.getFieldByBinding(property.getName());
    }

    protected FieldDefinition getFieldBy(Predicate<FieldDefinition> predicate) {
        Optional<FieldDefinition> result;
        if (predicate != null && (result = this.fields.stream().filter(predicate).findFirst()).isPresent()) {
            return result.get();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormDefinition form = (FormDefinition)o;
        if (!this.id.equals(form.id)) {
            return false;
        }
        if (!this.name.equals(form.name)) {
            return false;
        }
        if (!this.model.equals(form.model)) {
            return false;
        }
        if (!this.fields.equals(form.fields)) {
            return false;
        }
        return this.layoutTemplate.equals((Object)form.layoutTemplate);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + this.model.hashCode();
        result = ~(~result);
        result = 31 * result + this.fields.hashCode();
        result = ~(~result);
        result = 31 * result + this.layoutTemplate.hashCode();
        result = ~(~result);
        return result;
    }
}

