/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.EntrySource;
import com.unboundid.ldap.sdk.EntrySourceException;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFEntrySource
extends EntrySource {
    private final AtomicBoolean closed;
    private final LDIFReader ldifReader;

    public LDIFEntrySource(LDIFReader ldifReader) {
        Validator.ensureNotNull(ldifReader);
        this.ldifReader = ldifReader;
        this.closed = new AtomicBoolean(false);
    }

    public Entry nextEntry() throws EntrySourceException {
        if (this.closed.get()) {
            return null;
        }
        try {
            Entry e = this.ldifReader.readEntry();
            if (e == null) {
                this.close();
            }
            return e;
        }
        catch (LDIFException le) {
            Debug.debugException(le);
            if (le.mayContinueReading()) {
                throw new EntrySourceException(true, (Throwable)le);
            }
            this.close();
            throw new EntrySourceException(false, (Throwable)le);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.close();
            throw new EntrySourceException(false, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.ldifReader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }
}

