/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.execmodelbased.DTableModel;
import org.kie.dmn.core.compiler.execmodelbased.FeelValue;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;

public class DecisionTableEvaluator {
    private final DTableModel dTableModel;
    private final EvaluationContext evalCtx;
    private final FeelValue[] inputs;
    private final List<FEELEvent> events;
    private final EvaluationContext[] columnEvalCtxs;
    private final List<Integer> indexes = new ArrayList<Integer>();

    public DecisionTableEvaluator(DMNFEELHelper feel, DTableModel dTableModel, EvaluationContext evalCtx, List<FEELEvent> events) {
        this.dTableModel = dTableModel;
        this.evalCtx = evalCtx;
        this.events = events;
        this.inputs = new FeelValue[dTableModel.getColumns().size()];
        this.columnEvalCtxs = new EvaluationContext[dTableModel.getColumns().size()];
        this.initInputs(feel);
    }

    public Object getOutput(int row, int col) {
        return this.dTableModel.getRows().get(row).evaluate(this.evalCtx, col);
    }

    private Object[] initInputs(DMNFEELHelper feel) {
        Map allValues = this.evalCtx.getAllValues();
        for (int i = 0; i < this.inputs.length; ++i) {
            Object result = this.dTableModel.getColumns().get(i).evaluate(this.evalCtx);
            this.inputs[i] = new FeelValue(result);
            this.columnEvalCtxs[i] = feel.newEvaluationContext(Collections.singletonList(this.events::add), allValues);
            this.columnEvalCtxs[i].enterFrame();
            this.columnEvalCtxs[i].setValue("?", result);
        }
        return this.inputs;
    }

    public FeelValue[] getInputs() {
        return this.inputs;
    }

    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public void registerFire(int row) {
        this.indexes.add(row);
    }

    public boolean hasDefaultValues() {
        return this.dTableModel.hasDefaultValues();
    }

    public Object defaultToOutput(EvaluationContext ctx) {
        return this.dTableModel.defaultToOutput(ctx);
    }

    public HitPolicy getHitPolicy() {
        return this.dTableModel.getHitPolicy();
    }

    public EvaluationContext getEvalCtx(int col) {
        return this.columnEvalCtxs[col];
    }
}

