/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.ResourceTypePackageRegistry;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNPackage;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.dmn.core.impl.DMNRuntimeKB;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeKBWrappingIKB
implements DMNRuntimeKB {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeKBWrappingIKB.class);
    private final InternalKnowledgeBase knowledgeBase;

    public DMNRuntimeKBWrappingIKB(InternalKnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    @Override
    public List<DMNRuntimeEventListener> getListeners() {
        if (this.knowledgeBase != null && this.knowledgeBase instanceof KnowledgeBaseImpl && ((KnowledgeBaseImpl)this.knowledgeBase).getKieContainer() instanceof KieContainerImpl) {
            KieBaseModelImpl kieBaseModel = (KieBaseModelImpl)((KieContainerImpl)((KnowledgeBaseImpl)this.knowledgeBase).getKieContainer()).getKieProject().getKieBaseModel(this.knowledgeBase.getId());
            return kieBaseModel.getKModule().getConfigurationProperties().entrySet().stream().filter(kv -> kv.getKey() != null && ((String)kv.getKey()).startsWith("org.kie.dmn.runtime.listeners.")).map(Map.Entry::getValue).map(this::loadEventListener).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
        }
        logger.warn("No DMNRuntime Listener can be provided, as created without a reference to KnowledgeBase");
        return Collections.emptyList();
    }

    private Optional<DMNRuntimeEventListener> loadEventListener(String classString) {
        if (ClassLoaderUtil.CAN_PLATFORM_CLASSLOAD) {
            try {
                DMNRuntimeEventListener runtimeListenerInstance = (DMNRuntimeEventListener)this.knowledgeBase.getRootClassLoader().loadClass(classString).newInstance();
                return Optional.of(runtimeListenerInstance);
            }
            catch (Exception e) {
                logger.error("Cannot perform classloading of runtime listener: {}", (Object)classString, (Object)e);
                return Optional.empty();
            }
        }
        logger.error("This platform does not support classloading of runtime listener: {}", (Object)classString);
        return Optional.empty();
    }

    @Override
    public List<DMNModel> getModels() {
        ArrayList<DMNModel> models = new ArrayList<DMNModel>();
        this.knowledgeBase.getKiePackages().forEach(kpkg -> {
            DMNPackage dmnPkg = (DMNPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                dmnPkg.getAllModels().values().forEach(model -> models.add((DMNModel)model));
            }
        });
        return models;
    }

    @Override
    public DMNModel getModel(String namespace, String modelName) {
        Objects.requireNonNull(namespace, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "namespace"));
        Objects.requireNonNull(modelName, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "modelName"));
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.knowledgeBase.getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        ResourceTypePackageRegistry map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModel(modelName) : null;
    }

    @Override
    public DMNModel getModelById(String namespace, String modelId) {
        Objects.requireNonNull(namespace, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "namespace"));
        Objects.requireNonNull(modelId, () -> MsgUtil.createMessage(Msg.PARAM_CANNOT_BE_NULL, "modelId"));
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.knowledgeBase.getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        ResourceTypePackageRegistry map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModelById(modelId) : null;
    }

    @Override
    public List<DMNProfile> getProfiles() {
        ArrayList<DMNProfile> profiles = new ArrayList<DMNProfile>();
        this.knowledgeBase.getKiePackages().forEach(kpkg -> {
            DMNPackageImpl dmnPkg = (DMNPackageImpl)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                for (DMNProfile p : dmnPkg.getProfiles()) {
                    if (profiles.contains(p)) continue;
                    profiles.add(p);
                }
            }
        });
        return profiles;
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.knowledgeBase.getRootClassLoader();
    }

    @Override
    public InternalKnowledgeBase getInternalKnowledgeBase() {
        return this.knowledgeBase;
    }
}

