/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class DeletePopUpPresenter {
    private Validator validator;
    private ParameterizedCommand<String> command;
    private View view;
    private ToggleCommentPresenter toggleCommentPresenter;
    private boolean opened = false;

    @Inject
    public DeletePopUpPresenter(View view, ToggleCommentPresenter toggleCommentPresenter) {
        this.view = view;
        this.toggleCommentPresenter = toggleCommentPresenter;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(ParameterizedCommand<String> command) {
        this.show(null, command);
    }

    public void show(Validator validator, ParameterizedCommand<String> command) {
        this.validator = validator == null ? this.defaultValidator() : validator;
        this.command = command;
        this.opened = true;
        this.view.show();
    }

    public void cancel() {
        this.opened = false;
        this.view.hide();
    }

    Validator getValidator() {
        return this.validator;
    }

    public ParameterizedCommand<String> getCommand() {
        return this.command;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void delete() {
        PortablePreconditions.checkNotNull((String)"command", this.command);
        this.validator.validate(null, this.validatorCallback(this.toggleCommentPresenter.getComment()));
    }

    private ValidatorWithReasonCallback validatorCallback(final String comment) {
        return new ValidatorWithReasonCallback(){

            @Override
            public void onFailure(String reason) {
                if (ValidationErrorReason.NOT_ALLOWED.name().equals(reason)) {
                    DeletePopUpPresenter.this.view.handleDeleteNotAllowed();
                } else {
                    DeletePopUpPresenter.this.view.handleUnexpectedError();
                }
            }

            @Override
            public void onSuccess() {
                DeletePopUpPresenter.this.command.execute((Object)comment);
                DeletePopUpPresenter.this.view.hide();
                DeletePopUpPresenter.this.opened = false;
            }

            @Override
            public void onFailure() {
                DeletePopUpPresenter.this.view.handleUnexpectedError();
            }
        };
    }

    private Validator defaultValidator() {
        return (value, callback) -> callback.onSuccess();
    }

    public void setPrompt(String prompt) {
        this.view.setPrompt(prompt);
    }

    public void setCommentIsHidden(boolean hidden) {
        this.toggleCommentPresenter.setHidden(hidden);
    }

    public ToggleCommentPresenter getToggleCommentPresenter() {
        return this.toggleCommentPresenter;
    }

    public static interface View
    extends UberElement<DeletePopUpPresenter> {
        public void show();

        public void hide();

        public void setPrompt(String var1);

        public void handleDeleteNotAllowed();

        public void handleUnexpectedError();
    }
}

