/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.Source;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class InMemorySourceRegistry
implements SourceRegistry {
    private Map<Path, Repository> repositorySourcesPath = new ConcurrentHashMap<Path, Repository>();
    private Map<String, Path> pathByRepositoryId = new ConcurrentHashMap<String, Path>();
    private Map<Repository, List<Source>> sourceByRepo = new ConcurrentHashMap<Repository, List<Source>>();
    private Map<Source, Project> projectBySource = new ConcurrentHashMap<Source, Project>();

    @Override
    public void registerRepositorySources(Path path, Repository repo) {
        this.repositorySourcesPath.put(path, repo);
        this.pathByRepositoryId.put(repo.getId(), path);
    }

    @Override
    public List<Repository> getAllRepositories() {
        return new ArrayList<Repository>(this.repositorySourcesPath.values());
    }

    @Override
    public List<Project> getAllProjects(Repository repository) {
        Path repoPath = this.pathByRepositoryId.get(repository.getId());
        ArrayList<Project> allProjects = new ArrayList<Project>();
        for (Source s : this.projectBySource.keySet()) {
            if (!this.projectBySource.get(s).getRootPath().equals(repoPath)) continue;
            allProjects.add(this.projectBySource.get(s));
        }
        return allProjects;
    }

    @Override
    public void registerSource(Repository repo, Source source) {
        this.sourceByRepo.putIfAbsent(repo, new ArrayList());
        this.sourceByRepo.get(repo).add(source);
    }

    @Override
    public void registerProject(Source source, Project project) {
        this.projectBySource.put(source, project);
    }
}

