/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class MediaStream implements EventTarget {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorStreamOrTracksUnionType {
    @JsOverlay
    static ConstructorStreamOrTracksUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default MediaStream asMediaStream() {
      return Js.cast(this);
    }

    @JsOverlay
    default MediaStreamTrack[] asMediaStreamTrackArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isMediaStream() {
      return (Object) this instanceof MediaStream;
    }

    @JsOverlay
    default boolean isMediaStreamTrackArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsFunction
  public interface OnactiveCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnaddtrackCallbackFn {
    Object onInvoke(MediaStreamTrackEvent p0);
  }

  @JsFunction
  public interface OnendedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OninactiveCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnremovetrackCallbackFn {
    Object onInvoke(MediaStreamTrackEvent p0);
  }

  public boolean active;
  public boolean ended;
  public String id;
  public String label;
  public OnactiveCallbackFn onactive;
  public OnaddtrackCallbackFn onaddtrack;
  public OnendedCallbackFn onended;
  public OninactiveCallbackFn oninactive;
  public OnremovetrackCallbackFn onremovetrack;

  public MediaStream() {}

  public MediaStream(ConstructorStreamOrTracksUnionType streamOrTracks) {}

  public MediaStream(MediaStream streamOrTracks) {}

  public MediaStream(MediaStreamTrack[] streamOrTracks) {}

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType useCapture);

  public native void addEventListener(String type, EventListener listener);

  public native void addTrack(MediaStreamTrack track);

  @JsMethod(name = "clone")
  public native MediaStream clone_();

  public native boolean dispatchEvent(Event evt);

  public native MediaStreamTrack[] getAudioTracks();

  public native MediaStreamTrack getTrackById(String trackId);

  public native MediaStreamTrack[] getTracks();

  public native MediaStreamTrack[] getVideoTracks();

  public native void removeEventListener(
      String type,
      EventListener listener,
      EventTarget.RemoveEventListenerOptionsUnionType useCapture);

  public native void removeEventListener(String type, EventListener listener);

  public native void removeTrack(MediaStreamTrack track);

  public native void stop();
}
