/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.config;

import org.guvnor.structure.backend.config.DefaultPasswordServiceImpl;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.PasswordService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.project.config.MigrationConfigurationFactoryImpl;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationConfigurationFactoryImplTest {
    private PasswordService passwordService;
    private ConfigurationFactory configurationFactory;

    @Before
    public void setup() {
        this.passwordService = new DefaultPasswordServiceImpl();
        this.configurationFactory = new MigrationConfigurationFactoryImpl(this.passwordService);
    }

    @Test
    public void newConfigGroupWithoutNamespaceTest() {
        ConfigGroup configGroup = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "my-config", "my-description");
        Assert.assertEquals((Object)ConfigType.GLOBAL, (Object)configGroup.getType());
        Assert.assertEquals((Object)"my-config", (Object)configGroup.getName());
        Assert.assertEquals((Object)"my-description", (Object)configGroup.getDescription());
        Assert.assertTrue((boolean)configGroup.isEnabled());
    }

    @Test
    public void newConfigGroupWithNamespaceTest() {
        ConfigGroup configGroup = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "my-namespace", "my-config", "my-description");
        Assert.assertEquals((Object)ConfigType.REPOSITORY, (Object)configGroup.getType());
        Assert.assertEquals((Object)"my-config", (Object)configGroup.getName());
        Assert.assertEquals((Object)"my-description", (Object)configGroup.getDescription());
        Assert.assertTrue((boolean)configGroup.isEnabled());
    }
}

