/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.command.registry.command;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.kie.workbench.common.command.Command;
import org.kie.workbench.common.command.registry.command.CommandRegistry;

public class CommandRegistryImpl<C extends Command>
implements CommandRegistry<C> {
    private final Deque<C> commands = new ArrayDeque<C>();
    private int maxStackSize = 200;

    @Override
    public void setMaxSize(int size) {
        this.maxStackSize = size;
    }

    @Override
    public void register(C command) {
        this.addIntoStack(command);
    }

    @Override
    public boolean remove(C command) {
        throw new UnsupportedOperationException("Remove not implemented yet.");
    }

    @Override
    public void clear() {
        this.commands.clear();
    }

    @Override
    public boolean contains(C item) {
        throw new UnsupportedOperationException("Contains not implemented yet.");
    }

    @Override
    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    @Override
    public List<C> getCommandHistory() {
        return new ArrayList<C>(this.commands);
    }

    @Override
    public C peek() {
        return (C)((Command)this.commands.peek());
    }

    @Override
    public C pop() {
        return (C)((Command)this.commands.pop());
    }

    private void addIntoStack(C command) {
        if (null != command) {
            if (this.commands.size() + 1 > this.maxStackSize) {
                this.commands.removeLast();
            }
            this.commands.push(command);
        }
    }
}

