/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.command.client;

import org.kie.workbench.common.command.client.Command;
import org.kie.workbench.common.command.client.CommandManager;
import org.kie.workbench.common.command.client.CommandResult;

public abstract class DelegateCommandManager<C, V>
implements CommandManager<C, V> {
    protected abstract CommandManager<C, V> getDelegate();

    @Override
    public CommandResult<V> allow(C context, Command<C, V> command) {
        if (null != this.getDelegate()) {
            this.preAllow(context, command);
            CommandResult<V> result = this.getDelegate().allow(context, command);
            this.postAllow(context, command, result);
            return result;
        }
        return null;
    }

    protected void preAllow(C context, Command<C, V> command) {
    }

    protected void postAllow(C context, Command<C, V> command, CommandResult<V> result) {
    }

    @Override
    public CommandResult<V> execute(C context, Command<C, V> command) {
        if (null != this.getDelegate()) {
            this.preExecute(context, command);
            CommandResult<V> result = this.getDelegate().execute(context, command);
            this.postExecute(context, command, result);
            return result;
        }
        return null;
    }

    protected void preExecute(C context, Command<C, V> command) {
    }

    protected void postExecute(C context, Command<C, V> command, CommandResult<V> result) {
    }

    @Override
    public CommandResult<V> undo(C context, Command<C, V> command) {
        if (null != this.getDelegate()) {
            this.preUndo(context, command);
            CommandResult<V> result = this.getDelegate().undo(context, command);
            this.postUndo(context, command, result);
            return result;
        }
        return null;
    }

    protected void preUndo(C context, Command<C, V> command) {
    }

    protected void postUndo(C context, Command<C, V> command, CommandResult<V> result) {
    }
}

