/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.command.client;

import java.util.Collection;
import java.util.LinkedList;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.impl.CommandResultImpl;

@NonPortable
public abstract class CommandResultBuilder<V> {
    private CommandResult.Type type = CommandResult.Type.INFO;
    private final Collection<V> violations = new LinkedList<V>();
    public static final CommandResult SUCCESS = new CommandResultImpl(CommandResult.Type.INFO, new LinkedList());
    public static final CommandResult FAILED = new CommandResultImpl(CommandResult.Type.ERROR, new LinkedList());

    public abstract CommandResult.Type getType(V var1);

    public CommandResultBuilder() {
    }

    public CommandResultBuilder(Collection<V> violations) {
        this.violations.addAll(violations);
    }

    public CommandResultBuilder<V> addViolation(V violation) {
        this.violations.add(violation);
        return this;
    }

    public CommandResultBuilder<V> addViolations(Collection<V> violations) {
        this.violations.addAll(violations);
        return this;
    }

    public CommandResultBuilder<V> setType(CommandResult.Type type) {
        this.type = type;
        return this;
    }

    public CommandResult<V> build() {
        this.violations.forEach(v -> {
            CommandResult.Type violationType = this.getType(v);
            if (violationType.getSeverity() > this.type.getSeverity()) {
                this.type = violationType;
            }
        });
        return new CommandResultImpl<V>(this.type, this.violations);
    }
}

