/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionsConverterTest {
    private final String NAMESPACE = "SomePreviousSetNamespace";
    @Mock
    private Definitions apiDefinitions;
    @Mock
    private org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wbDefinitions;

    @Test
    public void wbFromDMN() {
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wb = DefinitionsConverter.wbFromDMN((Definitions)this.apiDefinitions);
        String defaultNs = (String)wb.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = wb.getNamespace().getValue();
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
    }

    @Test
    public void dmnFromWB() {
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text());
        Definitions dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        String defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text("SomePreviousSetNamespace"));
        dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Assert.assertEquals((Object)"SomePreviousSetNamespace", (Object)defaultNs);
    }
}

