/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.QNamePropertyConverter;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={QNamePropertyConverter.class, InformationItemPrimaryPropertyConverter.class})
@RunWith(value=PowerMockRunner.class)
public class InformationItemPrimaryPropertyConverterTest {
    @Test
    public void testWbFromDMNWhenDMNIsNull() {
        InformationItem dmn = null;
        InformationItemPrimary informationItemPrimary = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn);
        Assert.assertNull((Object)informationItemPrimary);
    }

    @Test
    public void testWbFromDMNWhenDMNIsNotNull() {
        String id = "id";
        Id expectedId = new Id("id");
        QName expectedTypeRef = (QName)Mockito.mock(QName.class);
        javax.xml.namespace.QName qName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        InformationItem dmn = (InformationItem)Mockito.mock(InformationItem.class);
        PowerMockito.when((Object)dmn.getId()).thenReturn((Object)"id");
        PowerMockito.when((Object)dmn.getTypeRef()).thenReturn((Object)qName);
        PowerMockito.mockStatic(QNamePropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)qName, (DMNModelInstrumentedBase)dmn)).thenReturn((Object)expectedTypeRef);
        InformationItemPrimary informationItemPrimary = InformationItemPrimaryPropertyConverter.wbFromDMN((InformationItem)dmn);
        Id actualId = informationItemPrimary.getId();
        QName actualTypeRef = informationItemPrimary.getTypeRef();
        Assert.assertEquals((Object)expectedId, (Object)actualId);
        Assert.assertEquals((Object)expectedTypeRef, (Object)actualTypeRef);
    }

    @Test
    public void testDmnFromWBWhenWBIsNull() {
        InformationItemPrimary wb = null;
        TInformationItem informationItem = InformationItemPrimaryPropertyConverter.dmnFromWB(wb);
        Assert.assertNull((Object)informationItem);
    }

    @Test
    public void testDmnFromWBWhenWBIsNotNull() {
        String expectedId = "id";
        String expectedName = "name";
        Id id = new Id("id");
        InformationItemPrimary wb = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        QName qName = (QName)PowerMockito.mock(QName.class);
        javax.xml.namespace.QName expectedQName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        Optional<javax.xml.namespace.QName> optionalExpectedQName = Optional.of(expectedQName);
        PowerMockito.when((Object)wb.getId()).thenReturn((Object)id);
        PowerMockito.when((Object)wb.getTypeRef()).thenReturn((Object)qName);
        PowerMockito.stub((Method)PowerMockito.method(InformationItemPrimaryPropertyConverter.class, (String)"getName", (Class[])new Class[]{InformationItemPrimary.class})).toReturn((Object)"name");
        PowerMockito.stub((Method)PowerMockito.method(QNamePropertyConverter.class, (String)"dmnFromWB", (Class[])new Class[]{QName.class})).toReturn(optionalExpectedQName);
        TInformationItem informationItem = InformationItemPrimaryPropertyConverter.dmnFromWB((InformationItemPrimary)wb);
        String actualId = informationItem.getId();
        String actualName = informationItem.getName();
        javax.xml.namespace.QName actualQName = informationItem.getTypeRef();
        Assert.assertEquals((Object)"id", (Object)actualId);
        Assert.assertEquals((Object)"name", (Object)actualName);
        Assert.assertEquals((Object)expectedQName, (Object)actualQName);
    }

    @Test
    public void testGetNameWhenParentDoesNotHaveName() {
        InformationItemPrimary informationItem = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        InformationItemPrimary parent = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        PowerMockito.when((Object)informationItem.getParent()).thenReturn((Object)parent);
        String name = InformationItemPrimaryPropertyConverter.getName((InformationItemPrimary)informationItem);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testGetNameWhenParentHasNullName() {
        InformationItemPrimary informationItem = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        InputData parent = (InputData)Mockito.mock(InputData.class);
        PowerMockito.when((Object)informationItem.getParent()).thenReturn((Object)parent);
        PowerMockito.when((Object)parent.getName()).thenReturn(null);
        String name = InformationItemPrimaryPropertyConverter.getName((InformationItemPrimary)informationItem);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testGetNameWhenParentHasName() {
        InformationItemPrimary informationItem = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        InputData parent = (InputData)Mockito.mock(InputData.class);
        Name parentName = (Name)Mockito.mock(Name.class);
        String expectedName = "name";
        PowerMockito.when((Object)informationItem.getParent()).thenReturn((Object)parent);
        PowerMockito.when((Object)parent.getName()).thenReturn((Object)parentName);
        PowerMockito.when((Object)parentName.getValue()).thenReturn((Object)"name");
        String actualName = InformationItemPrimaryPropertyConverter.getName((InformationItemPrimary)informationItem);
        Assert.assertEquals((Object)"name", (Object)actualName);
    }
}

