/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.QNamePropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.UnaryTestsPropertyConverter;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={ItemDefinitionPropertyConverter.class, UnaryTestsPropertyConverter.class, DescriptionPropertyConverter.class, QNamePropertyConverter.class})
@RunWith(value=PowerMockRunner.class)
public class ItemDefinitionPropertyConverterTest {
    @Test
    public void testWbFromDMNWhenDMNIsNull() {
        Assert.assertNull((Object)ItemDefinitionPropertyConverter.wbFromDMN(null));
    }

    @Test
    public void testWbFromDMNWhenDMNIsNotNull() {
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String id = "id";
        String name = "name";
        Id expectedId = new Id("id");
        Name expectedName = new Name("name");
        String expectedTypeLanguage = "typeLanguage";
        boolean expectedIsCollection = true;
        Description expectedDescription = (Description)Mockito.mock(Description.class);
        QName expectedTypeRef = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)dmn.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmn.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmn.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmn.isIsCollection()).thenReturn((Object)true);
        this.stubWbDescriptionFromDMNToReturn(expectedDescription);
        this.stubWbTypeRefFromDMNToReturn(expectedTypeRef);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualItemDefinition = ItemDefinitionPropertyConverter.wbFromDMN((ItemDefinition)dmn);
        Id actualId = actualItemDefinition.getId();
        Name actualName = actualItemDefinition.getName();
        String actualTypeLanguage = actualItemDefinition.getTypeLanguage();
        boolean actualIsCollection = actualItemDefinition.isIsCollection();
        Description actualDescription = actualItemDefinition.getDescription();
        QName actualTypeRef = actualItemDefinition.getTypeRef();
        Assert.assertEquals((Object)expectedId, (Object)actualId);
        Assert.assertEquals((Object)expectedName, (Object)actualName);
        Assert.assertEquals((Object)"typeLanguage", (Object)actualTypeLanguage);
        Assert.assertEquals((Object)true, (Object)actualIsCollection);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
        Assert.assertEquals((Object)expectedTypeRef, (Object)actualTypeRef);
    }

    @Test
    public void testSetItemComponent() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wbChild = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition dmnChild = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        this.stubWbChildFromDMNToReturn(wbChild);
        Mockito.when((Object)dmn.getItemComponent()).thenReturn(Collections.singletonList(dmnChild));
        ItemDefinitionPropertyConverter.setItemComponent((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        List<org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition> expectedItemDefinitions = Collections.singletonList(wbChild);
        List actualItemDefinitions = wb.getItemComponent();
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNotNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests wbAllowedValues = (org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class);
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests dmnAllowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn((Object)dmnAllowedValues);
        PowerMockito.mockStatic(UnaryTestsPropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UnaryTestsPropertyConverter.wbFromDMN((UnaryTests)dmnAllowedValues)).thenReturn((Object)wbAllowedValues);
        ItemDefinitionPropertyConverter.setUnaryTests((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.verify((Object)wb)).setAllowedValues(wbAllowedValues);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.verify((Object)wbAllowedValues)).setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)wb);
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests wbAllowedValues = (org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class);
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests dmnAllowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn((Object)dmnAllowedValues);
        PowerMockito.mockStatic(UnaryTestsPropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UnaryTestsPropertyConverter.wbFromDMN((UnaryTests)dmnAllowedValues)).thenReturn(null);
        ItemDefinitionPropertyConverter.setUnaryTests((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.verify((Object)wb, (VerificationMode)Mockito.never())).setAllowedValues(wbAllowedValues);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.verify((Object)wbAllowedValues, (VerificationMode)Mockito.never())).setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)wb);
    }

    @Test
    public void testWbDescriptionFromDMN() {
        String description = "description";
        Description expectedDescription = (Description)Mockito.mock(Description.class);
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dmn.getDescription()).thenReturn((Object)"description");
        PowerMockito.mockStatic(DescriptionPropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DescriptionPropertyConverter.wbFromDMN((String)"description")).thenReturn((Object)expectedDescription);
        Description actualDescription = ItemDefinitionPropertyConverter.wbDescriptionFromDMN((ItemDefinition)dmn);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsUndefined() {
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        javax.xml.namespace.QName dmnQName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        QName wbQName = BuiltInType.UNDEFINED.asQName();
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)dmnQName);
        PowerMockito.mockStatic(QNamePropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmnQName, (DMNModelInstrumentedBase)dmn)).thenReturn((Object)wbQName);
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((ItemDefinition)dmn);
        Assert.assertNull((Object)actualQName);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsNotUndefined() {
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        javax.xml.namespace.QName dmnQName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        QName expectedQName = BuiltInType.STRING.asQName();
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)dmnQName);
        PowerMockito.mockStatic(QNamePropertyConverter.class, (Class[])new Class[0]);
        PowerMockito.when((Object)QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmnQName, (DMNModelInstrumentedBase)dmn)).thenReturn((Object)expectedQName);
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((ItemDefinition)dmn);
        Assert.assertEquals((Object)actualQName, (Object)expectedQName);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNotNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbParent = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbChild = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        ItemDefinition dmnChild = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        this.stubWbFromDMNToReturn(expectedWbChild);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)expectedWbParent, (ItemDefinition)dmnChild);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualParent = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)actualWbChild.getParent();
        Assert.assertEquals((Object)expectedWbChild, (Object)actualWbChild);
        Assert.assertEquals((Object)expectedWbParent, (Object)actualParent);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbParent = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        ItemDefinition dmnChild = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        this.stubWbFromDMNToReturn(null);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)expectedWbParent, (ItemDefinition)dmnChild);
        Assert.assertNull((Object)actualWbChild);
    }

    private void stubWbDescriptionFromDMNToReturn(Description returnValue) {
        Class<ItemDefinitionPropertyConverter> aClass = ItemDefinitionPropertyConverter.class;
        Class<ItemDefinition> parameter = ItemDefinition.class;
        PowerMockito.stub((Method)PowerMockito.method(aClass, (String)"wbDescriptionFromDMN", (Class[])new Class[]{parameter})).toReturn((Object)returnValue);
    }

    private void stubWbTypeRefFromDMNToReturn(QName returnValue) {
        Class<ItemDefinitionPropertyConverter> aClass = ItemDefinitionPropertyConverter.class;
        Class<ItemDefinition> parameter = ItemDefinition.class;
        PowerMockito.stub((Method)PowerMockito.method(aClass, (String)"wbTypeRefFromDMN", (Class[])new Class[]{parameter})).toReturn((Object)returnValue);
    }

    private void stubWbFromDMNToReturn(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition returnValue) {
        Class<ItemDefinitionPropertyConverter> aClass = ItemDefinitionPropertyConverter.class;
        Class<ItemDefinition> parameter = ItemDefinition.class;
        PowerMockito.stub((Method)PowerMockito.method(aClass, (String)"wbFromDMN", (Class[])new Class[]{parameter})).toReturn((Object)returnValue);
    }

    private void stubWbChildFromDMNToReturn(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition returnValue) {
        Class<ItemDefinitionPropertyConverter> aClass = ItemDefinitionPropertyConverter.class;
        Class<org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition> parameter1 = org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class;
        Class<ItemDefinition> parameter2 = ItemDefinition.class;
        PowerMockito.stub((Method)PowerMockito.method(aClass, (String)"wbChildFromDMN", (Class[])new Class[]{parameter1, parameter2})).toReturn((Object)returnValue);
    }

    @After
    public void validate() {
        Mockito.validateMockitoUsage();
    }
}

