/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.definition.v1_1.QNamePropertyConverter;

public class QNamePropertyConverterTest {
    static final Decision parent11 = new org.kie.dmn.model.v1_1.TDecision();
    static final Decision parent12;

    @Test
    public void testWBfromDMNnull() {
        QName wb = QNamePropertyConverter.wbFromDMN(null, (DMNModelInstrumentedBase)parent11);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb).isEqualTo((Object)BuiltInType.UNDEFINED.asQName());
    }

    @Test
    public void testDMNfromWBnull() {
        Optional dmn = QNamePropertyConverter.dmnFromWB((QName)new QName("", BuiltInType.UNDEFINED.getName(), DMNModelInstrumentedBase.Namespace.FEEL.getPrefix()));
        Assertions.assertThat((Optional)dmn).isEmpty();
    }

    @Test
    public void testWBfromDMNForBuiltInDataType11() {
        javax.xml.namespace.QName dmn = new javax.xml.namespace.QName("", BuiltInType.STRING.getName(), DMNModelInstrumentedBase.Namespace.FEEL.getPrefix());
        QName wb = QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmn, (DMNModelInstrumentedBase)parent11);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getNamespaceURI()).isEqualTo((Object)"");
        Assertions.assertThat((String)wb.getLocalPart()).isEqualTo((Object)BuiltInType.STRING.getName());
        Assertions.assertThat((String)wb.getPrefix()).isEqualTo((Object)"");
    }

    @Test
    public void testWBfromDMNForBuiltInDataType11variant() {
        org.kie.dmn.model.v1_1.TDecision parent11_variant = new org.kie.dmn.model.v1_1.TDecision();
        String nonTrivialFEELPrefix = "friendlyenough";
        parent11_variant.getNsContext().put("friendlyenough", parent11_variant.getURIFEEL());
        javax.xml.namespace.QName dmn = new javax.xml.namespace.QName("", BuiltInType.STRING.getName(), "friendlyenough");
        QName wb = QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmn, (DMNModelInstrumentedBase)parent11_variant);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getNamespaceURI()).isEqualTo((Object)"");
        Assertions.assertThat((String)wb.getLocalPart()).isEqualTo((Object)BuiltInType.STRING.getName());
        Assertions.assertThat((String)wb.getPrefix()).isEqualTo((Object)"");
    }

    @Test
    public void testWBfromDMNForBuiltInDataType12() {
        javax.xml.namespace.QName dmn = new javax.xml.namespace.QName("", BuiltInType.STRING.getName());
        QName wb = QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmn, (DMNModelInstrumentedBase)parent12);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getNamespaceURI()).isEqualTo((Object)"");
        Assertions.assertThat((String)wb.getLocalPart()).isEqualTo((Object)BuiltInType.STRING.getName());
        Assertions.assertThat((String)wb.getPrefix()).isEqualTo((Object)"");
    }

    @Test
    public void testWBfromDMNCustomDataType() {
        javax.xml.namespace.QName dmn = new javax.xml.namespace.QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), "tCustom", DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        QName wb = QNamePropertyConverter.wbFromDMN((javax.xml.namespace.QName)dmn, (DMNModelInstrumentedBase)parent11);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getNamespaceURI()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)wb.getLocalPart()).isEqualTo((Object)"tCustom");
        Assertions.assertThat((String)wb.getPrefix()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
    }

    static {
        parent11.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parent11.getURIFEEL());
        parent12 = new TDecision();
        parent12.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parent12.getURIFEEL());
    }
}

