/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.v1_2.TContext;
import org.kie.dmn.model.v1_2.TDecisionTable;
import org.kie.dmn.model.v1_2.TFunctionDefinition;
import org.kie.dmn.model.v1_2.TInvocation;
import org.kie.dmn.model.v1_2.TList;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.dmn.model.v1_2.TRelation;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExpressionPropertyConverterTest {
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN_LiteralExpressionConversion() {
        TLiteralExpression dmn = new TLiteralExpression();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, LiteralExpression.class);
    }

    private void assertWBFromDMNConversion(Expression dmn, Class wbClass) {
        org.kie.workbench.common.dmn.api.definition.v1_1.Expression wb = ExpressionPropertyConverter.wbFromDMN((Expression)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isInstanceOf(wbClass);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)wb);
    }

    @Test
    public void testDMNFromWB_LiteralExpressionConversion() {
        LiteralExpression wb = new LiteralExpression();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TLiteralExpression.class, 200.0);
    }

    private void assertDMNFromWBConversion(org.kie.workbench.common.dmn.api.definition.v1_1.Expression wb, Class dmnClass, double ... expectedComponentWidths) {
        Expression dmn = ExpressionPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isInstanceOf(dmnClass);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        List widths = componentWidths.getWidths();
        Assertions.assertThat((int)widths.size()).isEqualTo(wb.getRequiredComponentWidthCount());
        Assertions.assertThat((int)widths.size()).isEqualTo(expectedComponentWidths.length);
        IntStream.range(0, expectedComponentWidths.length).forEach(i -> Assertions.assertThat((Double)((Double)widths.get(i))).isEqualTo(expectedComponentWidths[i]));
    }

    @Test
    public void testWBFromDMN_ContextConversion() {
        TContext dmn = new TContext();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, Context.class);
    }

    @Test
    public void testDMNFromWB_ContextConversion() {
        Context wb = new Context();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wbComponentWidths.set(2, 300.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TContext.class, 100.0, 200.0, 300.0);
    }

    @Test
    public void testWBFromDMN_RelationConversion() {
        TRelation dmn = new TRelation();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, Relation.class);
    }

    @Test
    public void testDMNFromWB_RelationConversion() {
        Relation wb = new Relation();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TRelation.class, 200.0);
    }

    @Test
    public void testWBFromDMN_ListConversion() {
        TList dmn = new TList();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, org.kie.workbench.common.dmn.api.definition.v1_1.List.class);
    }

    @Test
    public void testDMNFromWB_ListConversion() {
        org.kie.workbench.common.dmn.api.definition.v1_1.List wb = new org.kie.workbench.common.dmn.api.definition.v1_1.List();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TList.class, 200.0);
    }

    @Test
    public void testWBFromDMN_InvocationConversion() {
        TInvocation dmn = new TInvocation();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, Invocation.class);
    }

    @Test
    public void testDMNFromWB_InvocationConversion() {
        Invocation wb = new Invocation();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wbComponentWidths.set(2, 300.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TInvocation.class, 100.0, 200.0, 300.0);
    }

    @Test
    public void testWBFromDMN_FunctionDefinitionConversion() {
        TFunctionDefinition dmn = new TFunctionDefinition();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, FunctionDefinition.class);
    }

    @Test
    public void testDMNFromWB_FunctionDefinitionConversion() {
        FunctionDefinition wb = new FunctionDefinition();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TFunctionDefinition.class, 100.0, 200.0);
    }

    @Test
    public void testWBFromDMN_DecisionTableConversion() {
        TDecisionTable dmn = new TDecisionTable();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((Expression)dmn, DecisionTable.class);
    }

    @Test
    public void testDMNFromWB_DecisionTableConversion() {
        DecisionTable wb = new DecisionTable();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb, TDecisionTable.class, 100.0, 200.0);
    }
}

