/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.backend.editors.types.DMNParseServiceImpl;

public class DMNParseServiceImplTest {
    private DMNParseServiceImpl service;

    @Before
    public void setup() {
        this.service = new DMNParseServiceImpl();
    }

    @Test
    public void testParseFEELListWithARegularNumberList() {
        List actualList = this.service.parseFEELList("1, 2, 3");
        List<String> expectedList = Arrays.asList("1", "2", "3");
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testParseFEELListWithARegularStringList() {
        List actualList = this.service.parseFEELList("\"Sao Paulo, SP\", \"Campinas, SP\", \"Rio de Janeiro, RJ\"");
        List<String> expectedList = Arrays.asList("\"Sao Paulo, SP\"", "\"Campinas, SP\"", "\"Rio de Janeiro, RJ\"");
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testParseFEELListWithAnArbitraryValue() {
        List actualList = this.service.parseFEELList("aaabbbcccdddeee");
        List<String> expectedList = Collections.singletonList("aaabbbcccdddeee");
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testParseFEELListWithASemicolon() {
        List actualList = this.service.parseFEELList("abcdef, \"Sao Paulo, SP\"; 123");
        List<String> expectedList = Arrays.asList("abcdef", "\"Sao Paulo, SP\"");
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testParseFEELListWithASpecialCharacter() {
        List actualList = this.service.parseFEELList("%20C");
        List expectedList = Collections.emptyList();
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testParseRange() {
        RangeValue rangeValue = this.service.parseRangeValue("[1..2]");
        Assert.assertTrue((boolean)rangeValue.getIncludeStartValue());
        Assert.assertTrue((boolean)rangeValue.getIncludeEndValue());
        Assert.assertEquals((Object)"1", (Object)rangeValue.getStartValue());
        Assert.assertEquals((Object)"2", (Object)rangeValue.getEndValue());
    }

    @Test
    public void testParseString() {
        RangeValue rangeValue = this.service.parseRangeValue("[abc..def]");
        Assert.assertTrue((boolean)rangeValue.getIncludeStartValue());
        Assert.assertTrue((boolean)rangeValue.getIncludeEndValue());
        Assert.assertEquals((Object)"abc", (Object)rangeValue.getStartValue());
        Assert.assertEquals((Object)"def", (Object)rangeValue.getEndValue());
    }

    @Test
    public void testParseStringWithDots() {
        RangeValue rangeValue = this.service.parseRangeValue("[\"abc..\"..\"d..ef\"]");
        Assert.assertTrue((boolean)rangeValue.getIncludeStartValue());
        Assert.assertTrue((boolean)rangeValue.getIncludeEndValue());
        Assert.assertEquals((Object)"\"abc..\"", (Object)rangeValue.getStartValue());
        Assert.assertEquals((Object)"\"d..ef\"", (Object)rangeValue.getEndValue());
    }

    @Test
    public void testParseWithInteger() {
        RangeValue rangeValue = this.service.parseRangeValue("[0..5]");
        Assert.assertTrue((boolean)rangeValue.getIncludeStartValue());
        Assert.assertTrue((boolean)rangeValue.getIncludeEndValue());
        Assert.assertEquals((Object)"0", (Object)rangeValue.getStartValue());
        Assert.assertEquals((Object)"5", (Object)rangeValue.getEndValue());
    }

    @Test
    public void testParseExcludeStart() {
        RangeValue rangeValue = this.service.parseRangeValue("(0..5]");
        Assert.assertFalse((boolean)rangeValue.getIncludeStartValue());
    }

    @Test
    public void testParseExcludeEnd() {
        RangeValue rangeValue = this.service.parseRangeValue("[0..5)");
        Assert.assertFalse((boolean)rangeValue.getIncludeEndValue());
    }

    @Test
    public void testParseFEELListMultipleCommasInside() {
        List actualList = this.service.parseFEELList("\"Sao Paulo, SP, South America\",\"New York, NY, North America\"");
        List<String> expectedList = Arrays.asList("\"Sao Paulo, SP, South America\"", "\"New York, NY, North America\"");
        Assert.assertEquals(expectedList, (Object)actualList);
    }
}

